/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.ios.eagl;

import com.jogamp.common.os.Platform;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.OffscreenLayerSurface;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.util.Map;
import jogamp.opengl.DummyGLExtProcAddressTable;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.ios.eagl.EAGL;
import jogamp.opengl.ios.eagl.IOSEAGLDrawable;
import jogamp.opengl.ios.eagl.IOSEAGLDrawableFactory;

public class IOSEAGLContext
extends GLContextImpl {
    private boolean haveSetOpenGLMode = false;
    private IOSEAGLDrawable.GLBackendType openGLMode = IOSEAGLDrawable.GLBackendType.CAEAGL_LAYER;
    protected GLBackendImpl impl;
    private DummyGLExtProcAddressTable cglExtProcAddressTable;

    static boolean isGLProfileSupported(int n, int n2, int n3) {
        return 0 != (8 & n);
    }

    static int GLProfile2EAGLProfileValue(int n, int n2, int n3) {
        if (!IOSEAGLContext.isGLProfileSupported(n, n2, n3)) {
            throw new GLException("OpenGL profile not supported.0: " + IOSEAGLContext.getGLVersion(n2, n3, n, "@GLProfile2EAGLProfileValue"));
        }
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new GLException("OpenGL profile not supported.1: " + IOSEAGLContext.getGLVersion(n2, n3, n, "@GLProfile2EAGLProfileValue"));
    }

    protected IOSEAGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void resetStates(boolean bl) {
        super.resetStates(bl);
    }

    @Override
    public Object getPlatformGLExtensions() {
        return null;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final DummyGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        if (!IOSEAGLContext.isGLProfileSupported(n, n2, n3)) {
            if (DEBUG) {
                System.err.println(IOSEAGLContext.getThreadName() + ": createContextARBImpl: Not supported " + IOSEAGLContext.getGLVersion(n2, n3, n, "@creation on iOS " + Platform.getOSVersionNumber()));
            }
            return 0L;
        }
        long l2 = this.impl.create(l, n, n2, n3);
        if (0L != l2) {
            if (!this.impl.makeCurrent(l2)) {
                if (DEBUG) {
                    System.err.println(IOSEAGLContext.getThreadName() + ": createContextARB couldn't make current " + IOSEAGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.impl.release(l2);
                this.impl.destroy(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(IOSEAGLContext.getThreadName() + ": createContextARBImpl: OK " + IOSEAGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl + " on iOS " + Platform.getOSVersionNumber());
            }
        } else if (DEBUG) {
            System.err.println(IOSEAGLContext.getThreadName() + ": createContextARBImpl: NO " + IOSEAGLContext.getGLVersion(n2, n3, n, "@creation on iOS " + Platform.getOSVersionNumber()));
        }
        return l2;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        this.impl.release(l);
        this.impl.destroy(l);
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return false;
    }

    @Override
    protected boolean createImpl(long l) throws GLException {
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = mutableGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = this.isCreateContextARBAvail(abstractGraphicsDevice);
        if (DEBUG) {
            System.err.println(IOSEAGLContext.getThreadName() + ": IOSEAGLContext.createImpl: START " + gLCapabilitiesImmutable + ", share " + IOSEAGLContext.toHexString(l));
            System.err.println(IOSEAGLContext.getThreadName() + ": Use ARB[avail[" + this.getCreateContextARBAvailStr(abstractGraphicsDevice) + "] -> " + bl + "]]");
        }
        if (!gLProfile.isGLES()) {
            throw new GLException("Desktop OpenGL profile not supported on iOS " + Platform.getOSVersionNumber() + ": " + gLProfile);
        }
        this.contextHandle = this.createContextARB(l, true);
        return 0L != this.contextHandle;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context current: " + this);
        }
        this.drawableUpdatedNotify();
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.contextHandle)) {
            throw new GLException("Error releasing OpenGL Context: " + this);
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        if (!this.impl.destroy(this.contextHandle)) {
            throw new GLException("Error destroying OpenGL Context: " + this);
        }
    }

    @Override
    protected void drawableUpdatedNotify() throws GLException {
    }

    @Override
    protected void associateDrawable(boolean bl) {
        boolean bl2;
        GLDrawableImpl gLDrawableImpl = this.getDrawableImpl();
        GLDrawableFactoryImpl gLDrawableFactoryImpl = gLDrawableImpl.getFactoryImpl();
        IOSEAGLDrawableFactory iOSEAGLDrawableFactory = gLDrawableFactoryImpl instanceof IOSEAGLDrawableFactory ? (IOSEAGLDrawableFactory)gLDrawableFactoryImpl : null;
        GLDrawableFactoryImpl.OnscreenFBOColorbufferStorageDefinition onscreenFBOColorbufferStorageDefinition = null != iOSEAGLDrawableFactory ? iOSEAGLDrawableFactory.getOnscreenFBOColorbufStorageDef() : null;
        GLFBODrawableImpl gLFBODrawableImpl = gLDrawableImpl instanceof GLFBODrawableImpl ? (GLFBODrawableImpl)gLDrawableImpl : null;
        boolean bl3 = bl2 = null != gLFBODrawableImpl && null != onscreenFBOColorbufferStorageDefinition ? gLFBODrawableImpl.hasColorRenderbufferStorageDef(onscreenFBOColorbufferStorageDefinition) : false;
        if (DEBUG) {
            System.err.println(IOSEAGLContext.getThreadName() + ": IOSEAGLContext.associateDrawable(bound " + bl + "): taggedOnscreenFBOEAGLLayer " + bl2 + ", hasFBODrawable " + (null != gLFBODrawableImpl) + ", drawable: " + this.getDrawableImpl().getClass().getName());
        }
        if (bl) {
            if (bl2) {
                gLFBODrawableImpl.setSwapBufferContext(new GLFBODrawableImpl.SwapBufferContext(){

                    @Override
                    public void swapBuffers(boolean bl) {
                        EAGL.eaglPresentRenderbuffer(IOSEAGLContext.this.contextHandle, 36161);
                    }
                });
            }
            super.associateDrawable(true);
            this.impl.associateDrawable(true);
        } else {
            this.impl.associateDrawable(false);
            super.associateDrawable(false);
            if (bl2) {
                EAGL.eaglBindDrawableStorageToRenderbuffer(this.contextHandle, 36161, 0L);
            }
        }
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        throw new GLException("copyImpl n/a: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable(String string, GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (null == gLDynamicLookupHelper) {
            throw new GLException("No GLDynamicLookupHelper for " + this);
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string2 = "iOS-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(IOSEAGLContext.getThreadName() + ": Initializing EAGL extension address table: " + string2);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string2);
        }
        if (null != procAddressTable) {
            this.cglExtProcAddressTable = (DummyGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(IOSEAGLContext.getThreadName() + ": GLContext CGL ProcAddressTable reusing key(" + string2 + ") -> " + IOSEAGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.cglExtProcAddressTable = new DummyGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getCGLExtProcAddressTable(), gLDynamicLookupHelper);
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string2, this.getCGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(IOSEAGLContext.getThreadName() + ": GLContext CGL ProcAddressTable mapping key(" + string2 + ") -> " + IOSEAGLContext.toHexString(((Object)((Object)this.getCGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        return new StringBuilder();
    }

    public void setOpenGLMode(IOSEAGLDrawable.GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using EAGL and ... more than once");
        }
        this.destroyImpl();
        ((IOSEAGLDrawable)this.drawable).setOpenGLMode(gLBackendType);
        if (DEBUG) {
            System.err.println("IOSEAGLContext: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final IOSEAGLDrawable.GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(IOSEAGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case CAEAGL_LAYER: {
                this.impl = new CAEAGLLayerImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    @Override
    protected Integer setSwapIntervalImpl2(int n) {
        return null;
    }

    protected static interface GLBackendImpl {
        public boolean isUsingCAEAGLLayer();

        public long create(long var1, int var3, int var4, int var5);

        public boolean destroy(long var1);

        public void associateDrawable(boolean var1);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);
    }

    class CAEAGLLayerImpl
    implements GLBackendImpl {
        private final OffscreenLayerSurface backingLayerHost = null;

        CAEAGLLayerImpl() {
        }

        @Override
        public boolean isUsingCAEAGLLayer() {
            return null != this.backingLayerHost;
        }

        @Override
        public long create(long l, int n, int n2, int n3) {
            long l2 = 0L;
            MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)IOSEAGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
            if (GLContext.DEBUG) {
                System.err.println("Share context for EAGL-based context is " + IOSEAGLContext.toHexString(l));
            }
            boolean bl = IOSEAGLContext.this.drawable instanceof GLFBODrawableImpl;
            int n4 = IOSEAGLContext.GLProfile2EAGLProfileValue(n, n2, n3);
            l2 = 0L != l ? EAGL.eaglCreateContextShared(n4, EAGL.eaglGetSharegroup(l)) : EAGL.eaglCreateContext(n4);
            if (0L != l2) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable2;
                if (bl) {
                    gLCapabilitiesImmutable2 = gLCapabilitiesImmutable;
                } else {
                    if (GLContext.DEBUG) {
                        System.err.println("Warning: CAEAGLLayer w/ non FBO caps");
                    }
                    gLCapabilitiesImmutable2 = gLCapabilitiesImmutable;
                }
                if (GLContext.DEBUG) {
                    System.err.println("NS create backingLayerHost: " + this.backingLayerHost);
                    System.err.println("NS create share: " + l);
                    System.err.println("NS create drawable type: " + IOSEAGLContext.this.drawable.getClass().getName());
                    System.err.println("NS create chosenCaps: " + gLCapabilitiesImmutable);
                    System.err.println("NS create fixedCaps: " + gLCapabilitiesImmutable2);
                    System.err.println("NS create drawable native-handle: " + IOSEAGLContext.toHexString(IOSEAGLContext.this.drawable.getHandle()));
                    System.err.println("NS create surface native-handle: " + IOSEAGLContext.toHexString(IOSEAGLContext.this.drawable.getNativeSurface().getSurfaceHandle()));
                }
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
                if (GLContext.DEBUG) {
                    System.err.println("EAGL create fixedCaps: " + gLCapabilitiesImmutable2);
                }
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            return EAGL.eaglDeleteContext(l, true);
        }

        @Override
        public void associateDrawable(boolean bl) {
        }

        @Override
        public boolean makeCurrent(long l) {
            return EAGL.eaglMakeCurrentContext(l);
        }

        @Override
        public boolean release(long l) {
            block3: {
                try {
                    if (IOSEAGLContext.this.hasRendererQuirk(7) && null != IOSEAGLContext.this.getGLProcAddressTable()) {
                        IOSEAGLContext.this.gl.glFlush();
                    }
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block3;
                    System.err.println("IOSEAGLContext.CGLImpl.release: INFO: glFlush() caught exception:");
                    gLException.printStackTrace();
                }
            }
            return EAGL.eaglMakeCurrentContext(0L);
        }
    }
}

