/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.ImageIcon;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.ImageUtils;
import tim.prune.save.xml.KmlExportOptions;
import tim.prune.save.xml.XmlUtils;

public abstract class KmlWriter {
    protected final TrackInfo _trackInfo;
    protected final KmlExportOptions _exportOptions;
    private final ProgressUpdater _progressUpdater;
    private boolean _cancelPressed = false;
    private Dimension[] _imageDimensions = null;

    public KmlWriter(TrackInfo trackInfo, KmlExportOptions kmlExportOptions, ProgressUpdater progressUpdater) {
        this._trackInfo = trackInfo;
        this._exportOptions = kmlExportOptions;
        this._progressUpdater = progressUpdater;
    }

    void cancelExport() {
        this._cancelPressed = true;
    }

    int exportData(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        boolean bl2 = this._exportOptions.getExportTrackPoints();
        boolean bl3 = this._exportOptions.getExportWaypoints();
        boolean bl4 = this._exportOptions.getExportPhotos();
        boolean bl5 = this._exportOptions.getExportAudios();
        boolean bl6 = this._exportOptions.getExportJustSelection();
        this.writeXmlHeader(outputStreamWriter);
        outputStreamWriter.write("<Folder>\n\t<name>");
        String string = this._exportOptions.getTitle();
        if (string != null && !string.equals("")) {
            outputStreamWriter.write(XmlUtils.fixCdata(string));
        } else {
            outputStreamWriter.write("Export from GpsPrune");
        }
        outputStreamWriter.write("</name>\n");
        int n = -1;
        int n2 = -1;
        if (bl6) {
            n = this._trackInfo.getSelection().getStart();
            n2 = this._trackInfo.getSelection().getEnd();
        }
        Track track = this._trackInfo.getTrack();
        boolean bl7 = this._exportOptions.getAbsoluteAltitudes();
        int n3 = track.getNumPoints();
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (!bl6 || n6 >= n && n6 <= n2) {
                DataPoint dataPoint = track.getPoint(n6);
                if (!dataPoint.hasMedia()) {
                    if (dataPoint.isWaypoint()) {
                        if (bl3) {
                            this.exportWaypoint(dataPoint, outputStreamWriter, bl7);
                            ++n4;
                        }
                    } else {
                        bl8 = true;
                    }
                }
                if (dataPoint.getPhoto() != null && dataPoint.getPhoto().isValid() && bl4) {
                    if (!bl9) {
                        outputStreamWriter.write("\t<Style id=\"camera_icon\"><IconStyle><Icon><href>https://maps.google.com/mapfiles/kml/pal4/icon46.png</href></Icon></IconStyle></Style>\n");
                        bl9 = true;
                    }
                    this.exportPhotoPoint(dataPoint, outputStreamWriter, bl, n6, ++n5, bl7);
                    ++n4;
                }
                if (dataPoint.getAudio() != null && bl5) {
                    if (!bl10) {
                        outputStreamWriter.write("\t<Style id=\"audio_icon\"><IconStyle><color>ff00ffff</color><Icon><href>https://maps.google.com/mapfiles/kml/shapes/star.png</href></Icon></IconStyle></Style>\n");
                        bl10 = true;
                    }
                    this.exportAudioPoint(dataPoint, outputStreamWriter, bl7);
                    ++n4;
                }
            }
            ++n6;
        }
        if (bl8 && bl2) {
            n4 += this.writeTrack(outputStreamWriter, bl7, n, n2);
        }
        outputStreamWriter.write("\n</Folder>\n</kml>\n");
        return n4;
    }

    protected abstract void writeXmlHeader(OutputStreamWriter var1) throws IOException;

    protected abstract int writeTrack(OutputStreamWriter var1, boolean var2, int var3, int var4) throws IOException;

    protected static String reverseRGB(String string) {
        if (string == null || string.length() != 6) {
            return string;
        }
        return String.valueOf(string.substring(4, 6)) + string.substring(2, 4) + string.substring(0, 2);
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        String string = dataPoint.getWaypointName().trim();
        this.exportNamedPoint(dataPoint, writer, string, dataPoint.getFieldValue(Field.DESCRIPTION), null, bl);
    }

    private void exportAudioPoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        String string = dataPoint.getAudio().getName();
        String string2 = null;
        if (dataPoint.getAudio().getFile() != null) {
            string2 = dataPoint.getAudio().getFile().getAbsolutePath();
        }
        this.exportNamedPoint(dataPoint, writer, string, string2, "audio_icon", bl);
    }

    private void exportPhotoPoint(DataPoint dataPoint, Writer writer, boolean bl, int n, int n2, boolean bl2) throws IOException {
        String string = dataPoint.getPhoto().getName();
        if (dataPoint.isWaypoint()) {
            string = dataPoint.getWaypointName();
        }
        String string2 = null;
        if (bl) {
            Dimension dimension = this._imageDimensions[n];
            string2 = "<![CDATA[<br/><table border='0'><tr><td><center><img src='images/image" + n2 + ".jpg' width='" + dimension.width + "' height='" + dimension.height + "'></center></td></tr>" + "<tr><td><center>" + string + KmlWriter.wrapInBrackets(this.getPhotoTimeString(dataPoint)) + "</center></td></tr>" + KmlWriter.wrapInTableRow(KmlWriter.getPointCaption(dataPoint)) + "</table>]]>";
        }
        this.exportNamedPoint(dataPoint, writer, string, string2, "camera_icon", bl2);
    }

    private void exportNamedPoint(DataPoint dataPoint, Writer writer, String string, String string2, String string3, boolean bl) throws IOException {
        Timestamp timestamp;
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(XmlUtils.fixCdata(string));
        writer.write("</name>\n");
        if (string2 != null) {
            writer.write("\t\t<description>");
            writer.write(XmlUtils.fixCdata(string2));
            writer.write("</description>\n");
        }
        if (string3 != null) {
            writer.write("\t\t<styleUrl>#");
            writer.write(string3);
            writer.write("</styleUrl>\n");
        }
        if ((timestamp = KmlWriter.getPointTimestamp(dataPoint)) != null && timestamp.isValid()) {
            writer.write("\t\t<Timestamp>\n\t\t\t<when>");
            writer.write(timestamp.getText(Timestamp.Format.ISO8601, null));
            writer.write("</when>\n\t\t</Timestamp>\n");
        }
        writer.write("\t\t<Point>\n");
        if (bl && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        } else {
            writer.write("\t\t\t<altitudeMode>clampToGround</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write(44);
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
        } else {
            writer.write(48);
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    void exportThumbnails(ZipOutputStream zipOutputStream, int n) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator == null || !iterator.hasNext()) {
            throw new IOException("no JPEG writer found");
        }
        ImageWriter imageWriter = iterator.next();
        boolean bl = this._exportOptions.getExportJustSelection();
        int n2 = -1;
        int n3 = -1;
        if (bl) {
            n2 = this._trackInfo.getSelection().getStart();
            n3 = this._trackInfo.getSelection().getEnd();
        }
        Track track = this._trackInfo.getTrack();
        int n4 = track.getNumPoints();
        this._imageDimensions = new Dimension[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4 && !this._cancelPressed) {
            DataPoint dataPoint = track.getPoint(n6);
            if (dataPoint.getPhoto() != null && dataPoint.getPhoto().isValid() && (!bl || n6 >= n2 && n6 <= n3)) {
                ZipEntry zipEntry = new ZipEntry("images/image" + ++n5 + ".jpg");
                zipOutputStream.putNextEntry(zipEntry);
                ImageIcon imageIcon = dataPoint.getPhoto().createImageIcon();
                BufferedImage bufferedImage = ImageUtils.rotateImage(imageIcon.getImage(), n, n, dataPoint.getPhoto().getRotationDegrees());
                this._imageDimensions[n6] = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                imageWriter.setOutput(ImageIO.createImageOutputStream(zipOutputStream));
                imageWriter.write(bufferedImage);
                zipOutputStream.closeEntry();
                if (this._progressUpdater != null) {
                    this._progressUpdater.setProgress(n5 + 1);
                }
            }
            ++n6;
        }
    }

    private String getPhotoTimeString(DataPoint dataPoint) {
        TimeZone timeZone = this._exportOptions.getTimezone();
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp().getTimeText(timeZone);
        }
        if (dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp().getTimeText(timeZone);
        }
        return null;
    }

    private static String wrapInBrackets(String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return " (" + string + ")";
    }

    private static String getPointCaption(DataPoint dataPoint) {
        String string = dataPoint.getFieldValue(Field.DESCRIPTION);
        if (string != null && !string.isBlank()) {
            return string;
        }
        return dataPoint.getFieldValue(Field.COMMENT);
    }

    private static String wrapInTableRow(String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return "<tr><td>" + string + "</td></tr>";
    }

    private static Timestamp getPointTimestamp(DataPoint dataPoint) {
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp();
        }
        if (dataPoint.getPhoto() != null && dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp();
        }
        if (dataPoint.getAudio() != null && dataPoint.getAudio().hasTimestamp()) {
            return dataPoint.getAudio().getTimestamp();
        }
        return null;
    }

    static interface ProgressUpdater {
        public void setProgress(int var1);
    }
}

