/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.AU;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Logger;

class VolumeDataReader
extends SurfaceReader {
    protected int dataType;
    protected boolean precalculateVoxelData;
    protected boolean allowMapData;
    protected P3 point;
    protected float ptsPerAngstrom;
    protected int maxGrid;
    protected boolean useOriginStepsPoints;

    VolumeDataReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initVDR(sg);
    }

    protected void initVDR(SurfaceGenerator sg) {
        this.initSR(sg);
        this.useOriginStepsPoints = this.params.origin != null && this.params.points != null && this.params.steps != null;
        this.dataType = this.params.dataType;
        this.precalculateVoxelData = true;
        this.allowMapData = true;
    }

    void setup(boolean isMapData) {
        this.jvxlFileHeaderBuffer = new SB().append("volume data read from file\n\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        this.initializeVolumetricData();
        return true;
    }

    @Override
    protected boolean readVolumeData(boolean isMapData) {
        try {
            this.readSurfaceData(isMapData);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void readVoxelDataIndividually(boolean isMapData) throws Exception {
        if (isMapData && !this.allowMapData) {
            return;
        }
        if (!isMapData || this.volumeData.sr != null) {
            this.voxelData = null;
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            return;
        }
        this.newVoxelDataCube();
        for (int x = 0; x < this.nPointsX; ++x) {
            float[][] plane = AU.newFloat2(this.nPointsY);
            this.voxelData[x] = plane;
            int ptyz = 0;
            for (int y = 0; y < this.nPointsY; ++y) {
                plane[y] = new float[this.nPointsZ];
                float[] strip = plane[y];
                int z = 0;
                while (z < this.nPointsZ) {
                    strip[z] = this.getValue(x, y, z, ptyz);
                    ++z;
                    ++ptyz;
                }
            }
        }
    }

    protected void setVolumeData() {
    }

    protected boolean setVolumeDataParams() {
        if (this.params.volumeData != null) {
            this.setVolumeDataV(this.params.volumeData);
            return true;
        }
        if (!this.useOriginStepsPoints) {
            return false;
        }
        this.volumetricOrigin.setT(this.params.origin);
        this.volumetricVectors[0].set(this.params.steps.x, 0.0f, 0.0f);
        this.volumetricVectors[1].set(0.0f, this.params.steps.y, 0.0f);
        this.volumetricVectors[2].set(0.0f, 0.0f, this.params.steps.z);
        this.voxelCounts[0] = (int)this.params.points.x;
        this.voxelCounts[1] = (int)this.params.points.y;
        this.voxelCounts[2] = (int)this.params.points.z;
        if (this.voxelCounts[0] < 1 || this.voxelCounts[1] < 1 || this.voxelCounts[2] < 1) {
            return false;
        }
        this.showGridInfo();
        return true;
    }

    protected void showGridInfo() {
        Logger.info("grid origin  = " + this.params.origin);
        Logger.info("grid steps   = " + this.params.steps);
        Logger.info("grid points  = " + this.params.points);
        this.ptTemp.x = this.params.steps.x * this.params.points.x;
        this.ptTemp.y = this.params.steps.y * this.params.points.y;
        this.ptTemp.z = this.params.steps.z * this.params.points.z;
        Logger.info("grid lengths = " + this.ptTemp);
        this.ptTemp.add(this.params.origin);
        Logger.info("grid max xyz = " + this.ptTemp);
    }

    protected int setVoxelRange(int index, float min, float max, float ptsPerAngstrom, int gridMax, float minPointsPerAngstrom) {
        int nGrid;
        if (min - max >= -1.0E-4f) {
            min = -10.0f;
            max = 10.0f;
        }
        float range = max - min;
        float resolution = this.params.resolution;
        if (resolution != Float.MAX_VALUE) {
            ptsPerAngstrom = resolution;
            minPointsPerAngstrom = 0.0f;
        }
        if ((nGrid = (int)Math.floor(range * ptsPerAngstrom) + 1) > gridMax) {
            if ((this.dataType & 0x100) > 0) {
                if (resolution == Float.MAX_VALUE) {
                    if (!this.isQuiet) {
                        Logger.info("Maximum number of voxels for index=" + index + " exceeded (" + nGrid + ") -- set to " + gridMax);
                    }
                    nGrid = gridMax;
                } else if (!this.isQuiet) {
                    Logger.info("Warning -- high number of grid points: " + nGrid);
                }
            } else if (resolution == Float.MAX_VALUE) {
                nGrid = gridMax;
            }
        }
        if (nGrid == 1) {
            nGrid = 2;
        }
        if ((ptsPerAngstrom = (float)(nGrid - 1) / range) < minPointsPerAngstrom) {
            ptsPerAngstrom = minPointsPerAngstrom;
            nGrid = (int)Math.floor(ptsPerAngstrom * range + 1.0f);
            ptsPerAngstrom = (float)(nGrid - 1) / range;
        }
        float d = this.volumeData.volumetricVectorLengths[index] = 1.0f / ptsPerAngstrom;
        this.voxelCounts[index] = nGrid;
        if (this.params.sbOut != null) {
            this.params.sbOut.append("isosurface resolution for axis " + (index + 1) + " set to " + ptsPerAngstrom + " points/Angstrom; " + this.voxelCounts[index] + " voxels\n");
        }
        switch (index) {
            case 0: {
                this.volumetricVectors[0].set(d, 0.0f, 0.0f);
                this.volumetricOrigin.x = min;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, d, 0.0f);
                this.volumetricOrigin.y = min;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, d);
                this.volumetricOrigin.z = min;
                if (this.isEccentric) {
                    this.eccentricityMatrix.rotate(this.volumetricOrigin);
                }
                if (this.center != null && !Float.isNaN(this.center.x)) {
                    this.volumetricOrigin.add(this.center);
                }
                if (this.params.sbOut == null) break;
                this.params.sbOut.append(this.voxelCounts[0] * this.voxelCounts[1] * this.voxelCounts[2] + " voxels total\n");
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.rotate(this.volumetricVectors[index]);
        }
        return this.voxelCounts[index];
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        this.readSurfaceDataVDR(isMapData);
    }

    protected void readSurfaceDataVDR(boolean isMapData) throws Exception {
        if (this.isProgressive && !isMapData) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            return;
        }
        if (this.precalculateVoxelData) {
            this.generateCube();
        } else {
            this.readVoxelDataIndividually(isMapData);
        }
    }

    protected void generateCube() {
        Logger.info("data type: user volumeData");
        Logger.info("voxel grid origin:" + this.volumetricOrigin);
        for (int i = 0; i < 3; ++i) {
            Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
        }
        Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
    }

    @Override
    protected void closeReader() {
    }
}

