/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import sun.security.action.GetLongAction;
import sun.security.ssl.CertificateMessage;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLAlgorithmDecomposer;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.StatusResponseManager;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;
import sun.security.util.LegacyAlgorithmConstraints;

class ServerHandshakeContext
extends HandshakeContext {
    static final boolean rejectClientInitiatedRenego = Utilities.getBooleanProperty("jdk.tls.rejectClientInitiatedRenegotiation", false);
    static final AlgorithmConstraints legacyAlgorithmConstraints = new LegacyAlgorithmConstraints("jdk.tls.legacyAlgorithms", new SSLAlgorithmDecomposer());
    SSLPossession interimAuthn;
    StatusResponseManager.StaplingParameters stapleParams;
    CertificateMessage.CertificateEntry currentCertEntry;
    private static final long DEFAULT_STATUS_RESP_DELAY = 5000L;
    final long statusRespTimeout;

    ServerHandshakeContext(SSLContextImpl sSLContextImpl, TransportContext transportContext) throws IOException {
        super(sSLContextImpl, transportContext);
        long l = AccessController.doPrivileged(new GetLongAction("jdk.tls.stapling.responseTimeout", 5000L));
        this.statusRespTimeout = l >= 0L ? l : 5000L;
        this.handshakeConsumers.put(SSLHandshake.CLIENT_HELLO.id, SSLHandshake.CLIENT_HELLO);
    }

    @Override
    void kickstart() throws IOException {
        if (!this.conContext.isNegotiated || this.kickstartMessageDelivered) {
            return;
        }
        SSLHandshake.kickstart(this);
        this.kickstartMessageDelivered = true;
    }
}

