/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

public class ProlongedTask<T>
extends UCPTaskBase<T>
implements Diagnosable {
    static final String CLASS_NAME = ProlongedTask.class.getName();
    private final ReentrantLock startStopLock = new ReentrantLock();
    private TaskHandle<T> m_taskHandle = null;

    public void start() {
        this.startStopLock.lock();
        try {
            if (null == this.m_taskHandle) {
                this.m_taskHandle = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(this);
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void stop() {
        block5: {
            this.startStopLock.lock();
            try {
                if (null == this.m_taskHandle) break block5;
                this.m_taskHandle.getTask().release();
                try {
                    this.m_taskHandle.get(100000L);
                }
                catch (TaskManagerException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
                }
                this.m_taskHandle = null;
            }
            finally {
                this.startStopLock.unlock();
            }
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }
}

