/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.logic.Constraint;

public class StrategyIndirectedPredicate<T1, T2>
implements Predicate<T1> {
    @Nonnull
    private final Function<T1, T2> objectLookupStrategy;
    @Nonnull
    private final Predicate<T2> predicate;

    public StrategyIndirectedPredicate(@ParameterName(name="objectStrategy") @Nonnull Function<T1, T2> objectStrategy, @ParameterName(name="pred") @Nonnull Predicate<T2> pred) {
        this.objectLookupStrategy = Constraint.isNotNull(objectStrategy, "Object lookup strategy cannot be null");
        this.predicate = Constraint.isNotNull(pred, "Predicate cannot be null");
    }

    public StrategyIndirectedPredicate(@ParameterName(name="objectStrategy") @Nonnull Function<T1, T2> objectStrategy, @ParameterName(name="collection") @Nonnull @NullableElements Collection<T2> collection) {
        this.objectLookupStrategy = Constraint.isNotNull(objectStrategy, "Object lookup strategy cannot be null");
        this.predicate = Predicates.in(collection);
    }

    @Override
    public boolean test(@Nullable T1 input) {
        return this.predicate.test(this.objectLookupStrategy.apply(input));
    }

    @Nonnull
    public static <T1, T2> StrategyIndirectedPredicate<T1, T2> forPredicate(@Nonnull Function<T1, T2> objectStrategy, @Nonnull Predicate<T2> pred) {
        return new StrategyIndirectedPredicate<T1, T2>(objectStrategy, pred);
    }

    @Nonnull
    public static <T1, T2> StrategyIndirectedPredicate<T1, T2> forCollection(@Nonnull Function<T1, T2> objectStrategy, @Nonnull Collection<T2> collection) {
        return new StrategyIndirectedPredicate<T1, T2>(objectStrategy, collection);
    }
}

