/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.components.ComponentGroup;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.options.PortSide;

public class ModelOrderComponentGroup
extends ComponentGroup {
    protected static final Multimap<Set<PortSide>, Set<PortSide>> MODEL_ORDER_CONSTRAINTS = HashMultimap.create();
    private List<LGraph> componentOrder = Lists.newLinkedList();

    static {
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NORTH_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_NORTH_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NORTH_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_EAST_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NORTH_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_NORTH_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH, PortSide.SIDES_NORTH_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_WEST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_EAST);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_NONE);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_NORTH);
        MODEL_ORDER_CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_SOUTH);
    }

    public ModelOrderComponentGroup() {
    }

    public ModelOrderComponentGroup(LGraph component) {
        this.add(component);
        this.getComponentOrder().add(component);
    }

    @Override
    public boolean add(LGraph component) {
        if (this.canAdd(component)) {
            this.components.put(component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS), component);
            this.getComponentOrder().add(component);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canAdd(LGraph component) {
        Set<PortSide> candidateSides = component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS);
        Collection constraints = CONSTRAINTS.get(candidateSides);
        Collection<Set<PortSide>> modelOrderConstraints = MODEL_ORDER_CONSTRAINTS.get(candidateSides);
        for (Set set : constraints) {
            if (this.components.get(set).isEmpty()) continue;
            return false;
        }
        for (Set set : modelOrderConstraints) {
            if (this.components.get(set).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<LGraph> getComponentOrder() {
        return this.componentOrder;
    }
}

