"""create section table

Revision ID: c4c0733acb37
Revises: 5d73a92c8979
Create Date: 2018-08-26 08:19:54.420484

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c4c0733acb37'
down_revision = '5d73a92c8979'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('section',
    sa.Column('sec_page', sa.Integer(), nullable=False),
    sa.Column('sec_number', sa.Integer(), nullable=False),
    sa.Column('sec_level', sa.Integer(), nullable=False),
    sa.Column('sec_title', sa.UnicodeText(), nullable=False),
    sa.Column('sec_anchor', sa.UnicodeText(), nullable=False),
    sa.CheckConstraint('sec_level >= 1 and sec_level <= 6', name='check_sec_level'),
    sa.CheckConstraint('sec_number > 0', name='check_sec_number'),
    sa.ForeignKeyConstraint(['sec_page'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.PrimaryKeyConstraint('sec_page', 'sec_number')
    )
    op.create_index('sec_page_anchor', 'section', ['sec_page', 'sec_anchor'], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('sec_page_anchor', table_name='section')
    op.drop_table('section')
    # ### end Alembic commands ###
