/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JViewport;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MapView;

public class FitToPage
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private MapView view;

    public FitToPage() {
        super("FitToPage");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.view = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (this.view == null) {
            return;
        }
        this.zoom();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FitToPage.this.scroll();
            }
        });
    }

    private void scroll() {
        Rectangle rect = this.view.getInnerBounds();
        Rectangle viewer = this.view.getVisibleRect();
        this.view.scrollBy(this.shift(rect.x, rect.width, viewer.x, viewer.width), this.shift(rect.y, rect.height, viewer.y, viewer.height));
    }

    private int shift(int coord1, int size1, int coord2, int size2) {
        return coord1 - coord2 + (size1 - size2) / 2;
    }

    private void zoom() {
        Rectangle rect = this.view.getInnerBounds();
        double oldZoom = this.view.getZoom();
        JViewport viewPort = (JViewport)this.view.getParent();
        Dimension viewer = viewPort.getExtentSize();
        double heightZoom = (double)viewer.height * oldZoom / ((double)rect.height + 0.0);
        double newZoom = (double)viewer.width * oldZoom / ((double)rect.width + 0.0);
        if (heightZoom < newZoom) {
            newZoom = heightZoom;
        }
        Controller.getCurrentController().getMapViewManager().setZoom((float)newZoom);
    }
}

