/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.ApplicationSecurityEnforcer;
import io.sf.carte.echosvg.util.EchoSVGSecurityManager;
import io.sf.carte.echosvg.util.Messages;
import java.net.URL;
import java.security.Policy;
import java.util.StringTokenizer;

@Deprecated
class SMApplicationSecurityEnforcer
extends ApplicationSecurityEnforcer {
    private static final String EXCEPTION_ALIEN_SECURITY_MANAGER = "ApplicationSecurityEnforcer.message.security.exception.alien.security.manager";
    private static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String JAR_URL_FILE_SEPARATOR = "!/";
    private static final String DEV_GRADLE_CLASS_DIR = "/build/classes/java/main/";
    private static final String DEV_GRADLE_TEST_CLASS_DIR = "/build/classes/java/test/";
    private static final String DEV_ECLIPSE_CLASS_DIR = "/bin/main/";
    private static final String DEV_ECLIPSE_TEST_CLASS_DIR = "/bin/test/";
    private String appMainClassRelativeURL;
    private EchoSVGSecurityManager lastSecurityManagerInstalled;
    private SecurityManager previousSecurityManagerInstalled = null;

    public SMApplicationSecurityEnforcer(Class<?> appMainClass, String securityPolicy) {
        super(appMainClass, securityPolicy);
        this.appMainClassRelativeURL = appMainClass.getName().replace('.', '/') + ".class";
    }

    @Override
    public void enforceSecurity(boolean enforce) {
        SecurityManager sm = System.getSecurityManager();
        if (!enforce && sm != null && sm != this.lastSecurityManagerInstalled && sm != this.previousSecurityManagerInstalled) {
            throw new SecurityException(Messages.getString(EXCEPTION_ALIEN_SECURITY_MANAGER));
        }
        if (enforce) {
            try {
                System.setSecurityManager(null);
                this.previousSecurityManagerInstalled = sm;
                this.installSecurityManager();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else if (sm != null) {
            System.setSecurityManager(this.previousSecurityManagerInstalled);
            this.lastSecurityManagerInstalled = null;
            this.previousSecurityManagerInstalled = null;
        }
    }

    @Override
    public URL getPolicyURL() {
        ClassLoader cl = this.getApplicationMainClass().getClassLoader();
        URL policyURL = cl.getResource(this.getSecurityPolicy());
        if (policyURL == null) {
            throw new NullPointerException(Messages.formatMessage("ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file", new Object[]{this.getSecurityPolicy()}));
        }
        return policyURL;
    }

    @Override
    public void installSecurityManager() {
        URL mainClassURL;
        Policy policy = Policy.getPolicy();
        EchoSVGSecurityManager securityManager = new EchoSVGSecurityManager();
        ClassLoader cl = this.getApplicationMainClass().getClassLoader();
        String securityPolicyProperty = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (securityPolicyProperty == null || securityPolicyProperty.equals("")) {
            URL policyURL = this.getPolicyURL();
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, policyURL.toString());
        }
        if ((mainClassURL = cl.getResource(this.appMainClassRelativeURL)) == null) {
            throw new RuntimeException(this.appMainClassRelativeURL);
        }
        String expandedMainClassName = mainClassURL.toString();
        if (expandedMainClassName.startsWith(JAR_PROTOCOL)) {
            this.setJarBase(expandedMainClassName);
        } else {
            this.setDevProperties(expandedMainClassName);
        }
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        if (gradleUserHome == null) {
            gradleUserHome = System.getProperty("user.home") + "/.gradle";
        }
        System.setProperty("gradle.user.home", gradleUserHome);
        System.setSecurityManager(securityManager);
        this.lastSecurityManagerInstalled = securityManager;
        policy.refresh();
        if (securityPolicyProperty == null || securityPolicyProperty.equals("")) {
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, "");
        }
    }

    private void setJarBase(String expandedMainClassName) {
        String curAppJarBase = System.getProperty("app.jar.base");
        if (curAppJarBase == null) {
            int codeBaseEnd = (expandedMainClassName = expandedMainClassName.substring(JAR_PROTOCOL.length())).indexOf(JAR_URL_FILE_SEPARATOR + this.appMainClassRelativeURL);
            if (codeBaseEnd == -1) {
                throw new RuntimeException("Unable to derive app.jar.base from: " + expandedMainClassName);
            }
            String appCodeBase = expandedMainClassName.substring(0, codeBaseEnd);
            appCodeBase = (codeBaseEnd = appCodeBase.lastIndexOf(47)) == -1 ? "" : appCodeBase.substring(0, codeBaseEnd);
            System.setProperty("app.jar.base", appCodeBase);
        }
    }

    private void setDevProperties(String expandedMainClassName) {
        String curAppCodeBase = System.getProperty("app.dev.base");
        String appClassDir = null;
        String appTestClassDir = null;
        String ideClassDir = null;
        if (curAppCodeBase == null) {
            int codeBaseEnd = expandedMainClassName.lastIndexOf(DEV_GRADLE_CLASS_DIR + this.appMainClassRelativeURL);
            if (codeBaseEnd == -1) {
                codeBaseEnd = expandedMainClassName.lastIndexOf(DEV_GRADLE_TEST_CLASS_DIR + this.appMainClassRelativeURL);
            }
            if (codeBaseEnd == -1) {
                codeBaseEnd = expandedMainClassName.lastIndexOf(DEV_ECLIPSE_CLASS_DIR + this.appMainClassRelativeURL);
                if (codeBaseEnd == -1) {
                    codeBaseEnd = expandedMainClassName.lastIndexOf(DEV_ECLIPSE_TEST_CLASS_DIR + this.appMainClassRelativeURL);
                }
                appClassDir = DEV_ECLIPSE_CLASS_DIR;
                appTestClassDir = DEV_ECLIPSE_TEST_CLASS_DIR;
                ideClassDir = SMApplicationSecurityEnforcer.getIDEClassDir();
            } else {
                appClassDir = DEV_GRADLE_CLASS_DIR;
                appTestClassDir = DEV_GRADLE_TEST_CLASS_DIR;
            }
            if (codeBaseEnd == -1 || (codeBaseEnd = expandedMainClassName.substring(0, codeBaseEnd).lastIndexOf(47)) == -1) {
                throw new RuntimeException("Unable to derive app.dev.base from: " + expandedMainClassName);
            }
            String appCodeBase = expandedMainClassName.substring(5, codeBaseEnd);
            if (ideClassDir != null) {
                System.setProperty("app.ide.classdir", ideClassDir);
            }
            System.setProperty("app.dev.base", appCodeBase);
            System.setProperty("app.dev.classdir", appClassDir);
            System.setProperty("app.dev.testdir", appTestClassDir);
        }
    }

    private static String getIDEClassDir() {
        String cp = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(cp, ";");
        while (st.hasMoreTokens()) {
            String cpe = st.nextToken();
            int idx = cpe.indexOf("org.eclipse.osgi");
            if (idx == -1) continue;
            return cpe.substring(0, idx + 16);
        }
        return null;
    }
}

