/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import org.w3c.dom.DOMException;

class HSLColorImpl
extends BaseColor
implements HSLColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue hue = null;
    private PrimitiveValue saturation = null;
    private PrimitiveValue lightness = null;

    HSLColorImpl() {
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HSL;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        HSLColorImpl setfrom = (HSLColorImpl)color;
        this.hue = setfrom.getHue();
        this.saturation = setfrom.getSaturation();
        this.lightness = setfrom.getLightness();
    }

    @Override
    public NumberValue component(String component) {
        NumberValue ret;
        switch (component) {
            case "h": {
                ret = HSLColorImpl.hueComponent((CSSTypedValue)((Object)this.getHue()));
                break;
            }
            case "s": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getSaturation()), 1.0f);
                break;
            }
            case "l": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getLightness()), 1.0f);
                break;
            }
            case "alpha": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.alpha), 100.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getHue();
            }
            case 2: {
                return this.getSaturation();
            }
            case 3: {
                return this.getLightness();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setHue(component);
                break;
            }
            case 2: {
                this.setSaturation(component);
                break;
            }
            case 3: {
                this.setLightness(component);
            }
        }
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue hue) {
        this.hue = HSLColorImpl.enforceHueComponent(hue);
    }

    @Override
    public PrimitiveValue getSaturation() {
        return this.saturation;
    }

    public void setSaturation(PrimitiveValue saturation) {
        this.saturation = this.enforcePcntOrNumberComponent(saturation);
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue lightness) {
        this.lightness = this.enforcePcntOrNumberComponent(lightness);
    }

    @Override
    boolean hasPercentageComponent() {
        return this.saturation != null && this.saturation.getUnitType() == 2 || this.lightness != null && this.lightness.getUnitType() == 2;
    }

    @Override
    boolean hasConvertibleComponents() {
        return HSLColorImpl.isConvertibleComponent(this.getSaturation()) && HSLColorImpl.isConvertibleComponent(this.getHue()) && HSLColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    void setColorComponents(double[] hsl) {
        NumberValue h = NumberValue.createCSSNumberValue((short)80, (float)hsl[0]);
        h.setSubproperty(true);
        h.setAbsolutizedUnit();
        this.setHue(h);
        PercentageValue s = new PercentageValue();
        s.setFloatValue((short)2, (float)hsl[1]);
        s.setSubproperty(true);
        s.setAbsolutizedUnit();
        this.setSaturation(s);
        PercentageValue l = new PercentageValue();
        l.setFloatValue((short)2, (float)hsl[2]);
        l.setSubproperty(true);
        l.setAbsolutizedUnit();
        this.setLightness(l);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] hsl = new double[]{ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getSaturation())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getLightness()))};
        return hsl;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double hue = ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())) / 360.0;
        float sat = ColorUtil.fraction((CSSTypedValue)((Object)this.getSaturation()));
        float light = ColorUtil.fraction((CSSTypedValue)((Object)this.getLightness()));
        double[] rgb = new double[3];
        HSLColorImpl.hslToSRGB(hue, sat, light, rgb);
        return rgb;
    }

    private static void hslToSRGB(double hue, float sat, float light, double[] rgb) {
        if (hue > 1.0) {
            hue -= Math.floor(hue);
        } else if (hue < 0.0) {
            hue = hue - Math.floor(hue) + 1.0;
        }
        float m2 = light <= 0.5f ? light * (sat + 1.0f) : light + sat - light * sat;
        float m1 = light * 2.0f - m2;
        rgb[0] = HSLColorImpl.hueToRgb(m1, m2, hue + 0.3333333333333333);
        rgb[1] = HSLColorImpl.hueToRgb(m1, m2, hue);
        rgb[2] = HSLColorImpl.hueToRgb(m1, m2, hue - 0.3333333333333333);
    }

    private static double hueToRgb(float m1, float m2, double h) {
        if (h < 0.0) {
            h += 1.0;
        } else if (h > 1.0) {
            h -= 1.0;
        }
        if (h * 6.0 < 1.0) {
            return (double)m1 + (double)(m2 - m1) * h * 6.0;
        }
        if (h * 2.0 < 1.0) {
            return m2;
        }
        if (h * 3.0 < 2.0) {
            return (double)m1 + (double)(m2 - m1) * (0.6666666666666666 - h) * 6.0;
        }
        return m1;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    String toString(boolean commaSyntax) {
        boolean nonOpaque = this.isNonOpaque();
        if (commaSyntax) {
            return this.oldString(nonOpaque);
        }
        return this.newString(nonOpaque);
    }

    private String oldString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(22);
        if (nonOpaque) {
            buf.append("hsla(");
        } else {
            buf.append("hsl(");
        }
        this.appendHue(buf, this.hue);
        buf.append(", ").append(this.saturation.getCssText()).append(", ").append(this.lightness.getCssText());
        if (nonOpaque) {
            buf.append(", ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    private String newString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(20);
        buf.append("hsl(");
        this.appendHue(buf, this.hue);
        buf.append(' ').append(this.saturation.getCssText()).append(' ').append(this.lightness.getCssText());
        if (nonOpaque) {
            buf.append(" / ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String toMinifiedString() {
        return this.toMinifiedString(true);
    }

    String toMinifiedString(boolean commaSyntax) {
        boolean nonOpaque = this.isNonOpaque();
        if (commaSyntax) {
            return this.oldMinifiedString(nonOpaque);
        }
        return this.minifiedString(nonOpaque);
    }

    private String oldMinifiedString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(21);
        if (nonOpaque) {
            buf.append("hsla(");
        } else {
            buf.append("hsl(");
        }
        this.appendMinifiedHue(buf, this.hue);
        buf.append(',').append(this.saturation.getMinifiedCssText("color")).append(',').append(this.lightness.getMinifiedCssText("color"));
        if (nonOpaque) {
            buf.append(',');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    private String minifiedString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(20);
        buf.append("hsl(");
        this.appendMinifiedHue(buf, this.hue);
        buf.append(' ').append(this.saturation.getMinifiedCssText("color")).append(' ').append(this.lightness.getMinifiedCssText("color"));
        if (nonOpaque) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hue == null ? 0 : this.hue.hashCode());
        result = 31 * result + (this.lightness == null ? 0 : this.lightness.hashCode());
        result = 31 * result + (this.saturation == null ? 0 : this.saturation.hashCode());
        result = 31 * result + this.alpha.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSLColorImpl other = (HSLColorImpl)obj;
        if (this.hue == null ? other.hue != null : !this.hue.equals(other.hue)) {
            return false;
        }
        if (this.lightness == null ? other.lightness != null : !this.lightness.equals(other.lightness)) {
            return false;
        }
        if (this.saturation == null ? other.saturation != null : !this.saturation.equals(other.saturation)) {
            return false;
        }
        return this.alpha.equals(other.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new HSLColorValue(this);
    }

    @Override
    public HSLColorImpl clone() {
        HSLColorImpl clon = new HSLColorImpl();
        clon.alpha = this.alpha.clone();
        if (this.hue != null) {
            clon.hue = this.hue.clone();
        }
        if (this.saturation != null) {
            clon.saturation = this.saturation.clone();
        }
        if (this.lightness != null) {
            clon.lightness = this.lightness.clone();
        }
        return clon;
    }
}

