/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the sigmoid function pixel-wise.


A linear transformation is applied first on the argument of the
sigmoid function. The resulting total transform is given by

\\[ f(x) = (Max-Min) \\cdot \\frac{1}{\\left(1+e^{- \\frac{
x - \\beta }{\\alpha}}\\right)} + Min \\]

Every output pixel is equal to f(x). Where x is the intensity of the
homologous input pixel, and alpha and beta are user-provided
constants.
See:
 itk::simple::Sigmoid for the procedural interface

 itk::SigmoidImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSigmoidImageFilter.h
*/
public class SigmoidImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SigmoidImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SigmoidImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SigmoidImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SigmoidImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SigmoidImageFilter::~SigmoidImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SigmoidImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SigmoidImageFilter::SigmoidImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SigmoidImageFilter() {
    this(SimpleITKJNI.new_SigmoidImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SigmoidImageFilter::SetAlpha(double Alpha)
*/
public  void setAlpha(double Alpha) {
    SimpleITKJNI.SigmoidImageFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
double itk::simple::SigmoidImageFilter::GetAlpha() const
*/
public  double getAlpha() {
    return SimpleITKJNI.SigmoidImageFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SigmoidImageFilter::SetBeta(double Beta)
*/
public  void setBeta(double Beta) {
    SimpleITKJNI.SigmoidImageFilter_setBeta(swigCPtr, this, Beta);
  }

  /**
double itk::simple::SigmoidImageFilter::GetBeta() const
*/
public  double getBeta() {
    return SimpleITKJNI.SigmoidImageFilter_getBeta(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SigmoidImageFilter::SetOutputMaximum(double OutputMaximum)
*/
public  void setOutputMaximum(double OutputMaximum) {
    SimpleITKJNI.SigmoidImageFilter_setOutputMaximum(swigCPtr, this, OutputMaximum);
  }

  /**
double itk::simple::SigmoidImageFilter::GetOutputMaximum() const
*/
public  double getOutputMaximum() {
    return SimpleITKJNI.SigmoidImageFilter_getOutputMaximum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SigmoidImageFilter::SetOutputMinimum(double OutputMinimum)
*/
public  void setOutputMinimum(double OutputMinimum) {
    SimpleITKJNI.SigmoidImageFilter_setOutputMinimum(swigCPtr, this, OutputMinimum);
  }

  /**
double itk::simple::SigmoidImageFilter::GetOutputMinimum() const
*/
public  double getOutputMinimum() {
    return SimpleITKJNI.SigmoidImageFilter_getOutputMinimum(swigCPtr, this);
  }

  /**
std::string itk::simple::SigmoidImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SigmoidImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SigmoidImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SigmoidImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SigmoidImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SigmoidImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
