import { MatrixRoom } from "matrix-appservice-bridge";
import { IrcBridge } from "../bridge/IrcBridge";
import { BridgeRequest } from "../models/BridgeRequest";
import { IrcServer } from "./IrcServer";
/**
 * This class manages the visiblity of IRC messages on Matrix. It will check upon each IRC message
 * that all Matrix users are connected to the channel to avoid messages leaking to the Matrix side.
 *
 */
export declare class PrivacyProtection {
    private ircBridge;
    private readonly roomBlockedSet;
    private readonly memberListCache;
    private readonly syncsInProgress;
    constructor(ircBridge: IrcBridge);
    get blockedRoomCount(): number;
    /**
     * Clear the membership cache for a room.
     * @param roomId The Matrix room ID.
     */
    clearRoomFromCache(roomId: string): void;
    /**
     * Get a cached copy of all Matrix (not IRC) users in a room.
     * @param roomId The Matrix room to inspect.
     * @returns An array of Matrix userIDs.
     */
    private getMatrixUsersForRoom;
    /**
     * If configured, check to see if the all Matrix users in a given room are
     * joined to a channel. If they are not, drop the message.
     * @param req The IRC request
     * @param server The IRC server.
     */
    private shouldRequireMatrixUserJoined;
    /**
     * See if every joined Matrix user is also joined to the IRC channel. If they are not,
     * this returns false. A seperate mechanism should be use to join the user if this fails.
     * @param req The IRC request
     * @param server The IRC server
     * @param channel The IRC channel
     * @param roomId The Matrix room
     * @returns True if all users are connected and joined, or false otherwise.
     */
    private areAllMatrixUsersJoined;
    /**
     * Send a `org.matrix.appservice-irc.connection` state event into the room when a channel
     * is blocked or unblocked. Subsequent calls with the same state will no-op.
     * @param req The IRC request
     * @param roomId The Matrix room
     * @param channel The IRC room
     * @param blocked Is the channel blocked
     * @returns A promise, but it will always resolve.
     */
    private setBlockedStateInRoom;
    /**
     * Get rooms which are safe to bridge IRC messages to.
     * @param req The bridge request
     * @param server The IRC server
     * @param channel The IRC channel
     * @returns An array of Matrix rooms
     */
    getSafeRooms(req: BridgeRequest, server: IrcServer, channel: string): Promise<MatrixRoom[]>;
}
