/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1Constructed;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.util.Utils;

public class PKCS12CRLBag
extends PKCS12Bag {
    private PKCS12Safe c;
    private CRL d;
    private ASN1Sequence e;

    public PKCS12CRLBag() {
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe) {
        this.c = pKCS12Safe;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, CRL cRL) {
        this(pKCS12Safe);
        this.d = cRL;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.a(aSN1Sequence);
    }

    @Override
    void a() {
        this.e = null;
        if (this.c != null) {
            this.c.a();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.a(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.a(0);
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence2.a(0);
            if (!aSN1ObjectID.a(ASN1Utils.e, 9, 23, 1)) {
                throw new IOException("Unsupported CRL type " + aSN1ObjectID);
            }
            ASN1GenericConstructed aSN1GenericConstructed2 = (ASN1GenericConstructed)aSN1Sequence2.a(1);
            this.d = new CRL(new ByteArrayInputStream(((ASN1OctetString)aSN1GenericConstructed2.a(0)).b()));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.f().output(outputStream);
    }

    private ASN1Sequence f() {
        if (this.e != null) {
            return this.e;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 4));
        ASN1Constructed aSN1Constructed = new ASN1Sequence();
        aSN1Constructed.a(new ASN1ObjectID(ASN1Utils.e, 9, 23, 1));
        aSN1Constructed.a(new ASN1GenericConstructed(new ASN1OctetString(Utils.toBytes(this.d)), 0));
        aSN1Sequence.a(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.d();
        if (aSN1Constructed != null) {
            aSN1Sequence.a(aSN1Constructed);
        }
        this.e = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.f().length();
    }

    public CRL e() {
        return this.d;
    }

    public void a(CRL cRL) {
        this.d = cRL;
        this.a();
    }

    public String toString() {
        String string = "";
        if (this.a != null) {
            string = string + "friendlyName = \"" + this.a + "\", ";
        }
        if (this.b != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.b) + ", ";
        }
        return string + this.d.toString();
    }
}

