/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.model.ErrorNotification;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.indexstatemanagement.model.State;
import org.opensearch.indexmanagement.indexstatemanagement.model.Transition;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StateMetaData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB{\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017B\u0011\b\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u0016\u0010\u001aJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J\u0010\u00107\u001a\u0004\u0018\u00010\u00112\u0006\u00108\u001a\u000209J\t\u0010:\u001a\u00020\u0004H\u00c6\u0003J\t\u0010;\u001a\u00020\u0006H\u00c6\u0003J\t\u0010<\u001a\u00020\u0006H\u00c6\u0003J\t\u0010=\u001a\u00020\u0004H\u00c6\u0003J\t\u0010>\u001a\u00020\u0006H\u00c6\u0003J\t\u0010?\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010A\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0003J\u0011\u0010C\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003J\u0089\u0001\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00c6\u0001J\u0013\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u00d6\u0003J\t\u0010J\u001a\u00020KH\u00d6\u0001J\t\u0010L\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006N"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "id", "", "seqNo", "", "primaryTerm", "description", "schemaVersion", "lastUpdatedTime", "Ljava/time/Instant;", "errorNotification", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ErrorNotification;", "defaultState", "states", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/State;", "ismTemplate", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Ljava/lang/String;JJLjava/lang/String;JLjava/time/Instant;Lorg/opensearch/indexmanagement/indexstatemanagement/model/ErrorNotification;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/opensearch/commons/authuser/User;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getSeqNo", "()J", "getPrimaryTerm", "getDescription", "getSchemaVersion", "getLastUpdatedTime", "()Ljava/time/Instant;", "getErrorNotification", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/ErrorNotification;", "getDefaultState", "getStates", "()Ljava/util/List;", "getIsmTemplate", "getUser", "()Lorg/opensearch/commons/authuser/User;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "getDisallowedActions", "allowList", "getStateToExecute", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/Policy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1563#2:238\n1634#2,3:239\n1869#2:242\n1869#2,2:243\n1870#2:245\n1869#2,2:247\n1869#2:249\n1869#2,2:250\n1870#2:252\n1#3:246\n*S KotlinDebug\n*F\n+ 1 Policy.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/Policy\n*L\n46#1:238\n46#1:239,3\n47#1:242\n48#1:243,2\n47#1:245\n71#1:247,2\n131#1:249\n132#1:250,2\n131#1:252\n*E\n"})
public final class Policy
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final String description;
    private final long schemaVersion;
    @NotNull
    private final Instant lastUpdatedTime;
    @Nullable
    private final ErrorNotification errorNotification;
    @NotNull
    private final String defaultState;
    @NotNull
    private final List<State> states;
    @Nullable
    private final List<ISMTemplate> ismTemplate;
    @Nullable
    private final User user;
    @NotNull
    public static final String POLICY_TYPE = "policy";
    @NotNull
    public static final String POLICY_ID_FIELD = "policy_id";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String ERROR_NOTIFICATION_FIELD = "error_notification";
    @NotNull
    public static final String DEFAULT_STATE_FIELD = "default_state";
    @NotNull
    public static final String STATES_FIELD = "states";
    @NotNull
    public static final String ISM_TEMPLATE = "ism_template";
    @NotNull
    public static final String USER_FIELD = "user";

    /*
     * WARNING - void declaration
     */
    public Policy(@NotNull String id, long seqNo, long primaryTerm, @NotNull String description, long schemaVersion, @NotNull Instant lastUpdatedTime, @Nullable ErrorNotification errorNotification, @NotNull String defaultState, @NotNull List<State> states, @Nullable List<ISMTemplate> ismTemplate, @Nullable User user) {
        Object v0;
        block7: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
            Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
            Intrinsics.checkNotNullParameter((Object)defaultState, (String)"defaultState");
            Intrinsics.checkNotNullParameter(states, (String)STATES_FIELD);
            this.id = id;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.description = description;
            this.schemaVersion = schemaVersion;
            this.lastUpdatedTime = lastUpdatedTime;
            this.errorNotification = errorNotification;
            this.defaultState = defaultState;
            this.states = states;
            this.ismTemplate = ismTemplate;
            this.user = user;
            Iterable $this$map$iv = this.states;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                State state = (State)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List distinctStateNames = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$forEach$iv = this.states;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                State state = (State)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = state.getTransitions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Transition transition = (Transition)element$iv2;
                    boolean bl2 = false;
                    if (distinctStateNames.contains(transition.getStateName())) continue;
                    boolean bl3 = false;
                    String string = "Policy contains a transition in state=" + state.getName() + " pointing to a nonexistent state=" + transition.getStateName();
                    throw new IllegalArgumentException(string.toString());
                }
            }
            if (!(distinctStateNames.size() == this.states.size())) {
                boolean $i$a$-require-Policy$42 = false;
                String $i$a$-require-Policy$42 = "Policy cannot have duplicate state names";
                throw new IllegalArgumentException($i$a$-require-Policy$42.toString());
            }
            if (!(!((Collection)this.states).isEmpty())) {
                boolean $i$a$-require-Policy$52 = false;
                String $i$a$-require-Policy$52 = "Policy must contain at least one State";
                throw new IllegalArgumentException($i$a$-require-Policy$52.toString());
            }
            Iterable $i$a$-require-Policy$52 = this.states;
            for (Object t : $i$a$-require-Policy$52) {
                State it = (State)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.defaultState)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        if (v0 == null) {
            boolean bl = false;
            String string = "Policy must have a valid default state";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Policy(String string, long l, long l2, String string2, long l3, Instant instant, ErrorNotification errorNotification, String string3, List list, List list2, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            l = -2L;
        }
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 0x200) != 0) {
            list2 = null;
        }
        if ((n & 0x400) != 0) {
            user = null;
        }
        this(string, l, l2, string2, l3, instant, errorNotification, string3, list, list2, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ErrorNotification getErrorNotification() {
        return this.errorNotification;
    }

    @NotNull
    public final String getDefaultState() {
        return this.defaultState;
    }

    @NotNull
    public final List<State> getStates() {
        return this.states;
    }

    @Nullable
    public final List<ISMTemplate> getIsmTemplate() {
        return this.ismTemplate;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        return this.toXContent(builder, params);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        XContentBuilder xContentBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(POLICY_TYPE);
        }
        XContentBuilder xContentBuilder2 = builder.field(POLICY_ID_FIELD, this.id).field(DESCRIPTION_FIELD, this.description);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"field(...)");
        XContentBuilder it = xContentBuilder = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder2, LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(ERROR_NOTIFICATION_FIELD, (ToXContent)this.errorNotification).field(DEFAULT_STATE_FIELD, this.defaultState).startArray(STATES_FIELD);
        boolean bl = false;
        Iterable $this$forEach$iv = this.states;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            State state = (State)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            state.toXContent(it, params);
        }
        XContentBuilder xContentBuilder3 = xContentBuilder.endArray();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"endArray(...)");
        OpenSearchExtensionsKt.optionalISMTemplateField(xContentBuilder3, ISM_TEMPLATE, this.ismTemplate);
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder4 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder4, (String)"endObject(...)");
        return xContentBuilder4;
    }

    public Policy(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        long l = sin.readLong();
        long l2 = sin.readLong();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        long l3 = sin.readLong();
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        ErrorNotification errorNotification = (ErrorNotification)sin.readOptionalWriteable(ErrorNotification::new);
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        List list = sin.readList(State::new);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this(string, l, l2, string2, l3, instant, errorNotification, string3, list, sin.readBoolean() ? sin.readList(ISMTemplate::new) : null, sin.readBoolean() ? new User(sin) : null);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        block2: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeString(this.description);
            out.writeLong(this.schemaVersion);
            out.writeInstant(this.lastUpdatedTime);
            out.writeOptionalWriteable((Writeable)this.errorNotification);
            out.writeString(this.defaultState);
            out.writeList(this.states);
            if (this.ismTemplate != null) {
                out.writeBoolean(true);
                out.writeList(this.ismTemplate);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user == null) break block2;
            user.writeTo(out);
        }
    }

    @NotNull
    public final List<String> getDisallowedActions(@NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        Set allowListSet = CollectionsKt.toSet((Iterable)allowList);
        List disallowedActions = new ArrayList();
        Iterable $this$forEach$iv = this.states;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            State state = (State)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = state.getActions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Action actionConfig = (Action)element$iv2;
                boolean bl2 = false;
                if (allowListSet.contains(actionConfig.getType())) continue;
                disallowedActions.add(actionConfig.getType());
            }
        }
        return CollectionsKt.distinct((Iterable)disallowedActions);
    }

    @Nullable
    public final State getStateToExecute(@NotNull ManagedIndexMetaData managedIndexMetaData) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
            if (managedIndexMetaData.getTransitionTo() != null) {
                Object v0;
                block3: {
                    Iterable iterable = this.states;
                    for (Object t : iterable) {
                        State it = (State)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)managedIndexMetaData.getTransitionTo())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                return v0;
            }
            Iterable iterable = this.states;
            for (Object t : iterable) {
                State it = (State)t;
                boolean bl = false;
                StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
                if (!(stateMetaData != null && Intrinsics.areEqual((Object)it.getName(), (Object)stateMetaData.getName()))) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    @NotNull
    public final String component4() {
        return this.description;
    }

    public final long component5() {
        return this.schemaVersion;
    }

    @NotNull
    public final Instant component6() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ErrorNotification component7() {
        return this.errorNotification;
    }

    @NotNull
    public final String component8() {
        return this.defaultState;
    }

    @NotNull
    public final List<State> component9() {
        return this.states;
    }

    @Nullable
    public final List<ISMTemplate> component10() {
        return this.ismTemplate;
    }

    @Nullable
    public final User component11() {
        return this.user;
    }

    @NotNull
    public final Policy copy(@NotNull String id, long seqNo, long primaryTerm, @NotNull String description, long schemaVersion, @NotNull Instant lastUpdatedTime, @Nullable ErrorNotification errorNotification, @NotNull String defaultState, @NotNull List<State> states, @Nullable List<ISMTemplate> ismTemplate, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)defaultState, (String)"defaultState");
        Intrinsics.checkNotNullParameter(states, (String)STATES_FIELD);
        return new Policy(id, seqNo, primaryTerm, description, schemaVersion, lastUpdatedTime, errorNotification, defaultState, states, ismTemplate, user);
    }

    public static /* synthetic */ Policy copy$default(Policy policy2, String string, long l, long l2, String string2, long l3, Instant instant, ErrorNotification errorNotification, String string3, List list, List list2, User user, int n, Object object) {
        if ((n & 1) != 0) {
            string = policy2.id;
        }
        if ((n & 2) != 0) {
            l = policy2.seqNo;
        }
        if ((n & 4) != 0) {
            l2 = policy2.primaryTerm;
        }
        if ((n & 8) != 0) {
            string2 = policy2.description;
        }
        if ((n & 0x10) != 0) {
            l3 = policy2.schemaVersion;
        }
        if ((n & 0x20) != 0) {
            instant = policy2.lastUpdatedTime;
        }
        if ((n & 0x40) != 0) {
            errorNotification = policy2.errorNotification;
        }
        if ((n & 0x80) != 0) {
            string3 = policy2.defaultState;
        }
        if ((n & 0x100) != 0) {
            list = policy2.states;
        }
        if ((n & 0x200) != 0) {
            list2 = policy2.ismTemplate;
        }
        if ((n & 0x400) != 0) {
            user = policy2.user;
        }
        return policy2.copy(string, l, l2, string2, l3, instant, errorNotification, string3, list, list2, user);
    }

    @NotNull
    public String toString() {
        return "Policy(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", description=" + this.description + ", schemaVersion=" + this.schemaVersion + ", lastUpdatedTime=" + this.lastUpdatedTime + ", errorNotification=" + this.errorNotification + ", defaultState=" + this.defaultState + ", states=" + this.states + ", ismTemplate=" + this.ismTemplate + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.schemaVersion);
        result2 = result2 * 31 + this.lastUpdatedTime.hashCode();
        result2 = result2 * 31 + (this.errorNotification == null ? 0 : this.errorNotification.hashCode());
        result2 = result2 * 31 + this.defaultState.hashCode();
        result2 = result2 * 31 + ((Object)this.states).hashCode();
        result2 = result2 * 31 + (this.ismTemplate == null ? 0 : ((Object)this.ismTemplate).hashCode());
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Policy)) {
            return false;
        }
        Policy policy2 = (Policy)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)policy2.id)) {
            return false;
        }
        if (this.seqNo != policy2.seqNo) {
            return false;
        }
        if (this.primaryTerm != policy2.primaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)policy2.description)) {
            return false;
        }
        if (this.schemaVersion != policy2.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)policy2.lastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.errorNotification, (Object)policy2.errorNotification)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultState, (Object)policy2.defaultState)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.states, policy2.states)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ismTemplate, policy2.ismTemplate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)policy2.user);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Policy parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id, seqNo, primaryTerm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Policy parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
        return Companion.parse(xcp, id, seqNo);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Policy parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Policy parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy$Companion;", "", "<init>", "()V", "POLICY_TYPE", "", "POLICY_ID_FIELD", "DESCRIPTION_FIELD", "LAST_UPDATED_TIME_FIELD", "SCHEMA_VERSION_FIELD", "ERROR_NOTIFICATION_FIELD", "DEFAULT_STATE_FIELD", "STATES_FIELD", "ISM_TEMPLATE", "USER_FIELD", "parse", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/Policy$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Policy parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String description = null;
            String defaultState = null;
            ErrorNotification errorNotification = null;
            Instant lastUpdatedTime = null;
            long schemaVersion = 1L;
            List states = new ArrayList();
            List ismTemplates = null;
            User user = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block26: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block41: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block41;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1684719674: {
                            if (string.equals(Policy.SCHEMA_VERSION_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -1670470950: {
                            if (string.equals(Policy.LAST_UPDATED_TIME_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -225679544: {
                            if (string.equals(Policy.POLICY_ID_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case 1316456723: {
                            if (string.equals(Policy.DEFAULT_STATE_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case -998356810: {
                            if (string.equals(Policy.ISM_TEMPLATE)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals(Policy.DESCRIPTION_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 489205186: {
                            if (string.equals(Policy.ERROR_NOTIFICATION_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 3599307: {
                            if (string.equals(Policy.USER_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case -892482046: {
                            if (string.equals(Policy.STATES_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            continue block26;
                        }
                        case 1: {
                            schemaVersion = xcp.longValue();
                            continue block26;
                        }
                        case 2: {
                            lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                            continue block26;
                        }
                        case 6: {
                            description = xcp.text();
                            continue block26;
                        }
                        case 7: {
                            errorNotification = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ErrorNotification.Companion.parse(xcp);
                            continue block26;
                        }
                        case 4: {
                            defaultState = xcp.text();
                            continue block26;
                        }
                        case 9: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                states.add(State.Companion.parse(xcp));
                            }
                            continue block26;
                        }
                        case 5: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block26;
                            ismTemplates = new ArrayList();
                            XContentParser.Token token = xcp.currentToken();
                            switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
                                case 1: {
                                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                        ismTemplates.add(ISMTemplate.Companion.parse(xcp));
                                    }
                                    continue block26;
                                }
                                case 2: {
                                    ismTemplates.add(ISMTemplate.Companion.parse(xcp));
                                    continue block26;
                                }
                            }
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            continue block26;
                        }
                        case 8: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                            continue block26;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Policy.");
            }
            String string = id;
            long l = seqNo;
            long l2 = primaryTerm;
            String string2 = description;
            if (string2 == null) {
                long l3 = l2;
                long l4 = l;
                String string3 = string;
                boolean $i$a$-requireNotNull-Policy$Companion$parse$32 = false;
                String string4 = "description is null";
                String string5 = string3;
                long l5 = l4;
                long l6 = l3;
                String $i$a$-requireNotNull-Policy$Companion$parse$32 = string4;
                throw new IllegalArgumentException($i$a$-requireNotNull-Policy$Companion$parse$32.toString());
            }
            long l7 = schemaVersion;
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Instant $i$a$-requireNotNull-Policy$Companion$parse$32 = instant;
            Intrinsics.checkNotNull((Object)$i$a$-requireNotNull-Policy$Companion$parse$32);
            Instant instant2 = $i$a$-requireNotNull-Policy$Companion$parse$32;
            ErrorNotification errorNotification2 = errorNotification;
            String string6 = defaultState;
            if (string6 == null) {
                ErrorNotification errorNotification3 = errorNotification2;
                Instant instant3 = instant2;
                long l8 = l7;
                String string7 = string2;
                long l9 = l2;
                long l10 = l;
                String string8 = string;
                boolean bl = false;
                String string9 = "default_state is null";
                String string10 = string8;
                long l11 = l10;
                long l12 = l9;
                String string11 = string7;
                long l13 = l8;
                Instant instant4 = instant3;
                ErrorNotification errorNotification4 = errorNotification3;
                String string12 = string9;
                throw new IllegalArgumentException(string12.toString());
            }
            User user2 = user;
            List list = ismTemplates;
            List list2 = CollectionsKt.toList((Iterable)states);
            String string13 = string6;
            ErrorNotification errorNotification5 = errorNotification2;
            Instant instant5 = instant2;
            long l14 = l7;
            String string14 = string2;
            long l15 = l2;
            long l16 = l;
            String string15 = string;
            return new Policy(string15, l16, l15, string14, l14, instant5, errorNotification5, string13, list2, list, user2);
        }

        public static /* synthetic */ Policy parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Policy parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.indexstatemanagement.model.Policy$Companion.parse$default(this, xcp, id, seqNo, 0L, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Policy parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.indexstatemanagement.model.Policy$Companion.parse$default(this, xcp, id, 0L, 0L, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Policy parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.indexmanagement.indexstatemanagement.model.Policy$Companion.parse$default(this, xcp, null, 0L, 0L, 14, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[XContentParser.Token.values().length];
                try {
                    nArray[XContentParser.Token.START_ARRAY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[XContentParser.Token.START_OBJECT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

