/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.BlobStoreException;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.repositories.s3.AmazonAsyncS3Reference;
import org.opensearch.repositories.s3.AmazonS3Reference;
import org.opensearch.repositories.s3.GenericStatsMetricPublisher;
import org.opensearch.repositories.s3.S3AsyncService;
import org.opensearch.repositories.s3.S3BlobContainer;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.StatsMetricPublisher;
import org.opensearch.repositories.s3.async.AsyncExecutorContainer;
import org.opensearch.repositories.s3.async.AsyncTransferManager;
import org.opensearch.repositories.s3.async.SizeBasedBlockingQ;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.StorageClass;

public class S3BlobStore
implements BlobStore {
    private static final Logger logger = LogManager.getLogger(S3BlobStore.class);
    private final S3Service service;
    private final S3AsyncService s3AsyncService;
    private volatile String bucket;
    private volatile ByteSizeValue bufferSize;
    private volatile boolean redirectLargeUploads;
    private volatile boolean uploadRetryEnabled;
    private volatile boolean permitBackedTransferEnabled;
    private volatile String serverSideEncryptionType;
    private volatile String serverSideEncryptionKmsKey;
    private volatile boolean serverSideEncryptionBucketKey;
    private volatile String serverSideEncryptionEncryptionContext;
    private volatile String expectedBucketOwner;
    private volatile ObjectCannedACL cannedACL;
    private volatile StorageClass storageClass;
    private volatile int bulkDeletesSize;
    private volatile RepositoryMetadata repositoryMetadata;
    private final StatsMetricPublisher statsMetricPublisher = new StatsMetricPublisher();
    private final AsyncTransferManager asyncTransferManager;
    private final AsyncExecutorContainer urgentExecutorBuilder;
    private final AsyncExecutorContainer priorityExecutorBuilder;
    private final AsyncExecutorContainer normalExecutorBuilder;
    private final boolean multipartUploadEnabled;
    private final SizeBasedBlockingQ normalPrioritySizeBasedBlockingQ;
    private final SizeBasedBlockingQ lowPrioritySizeBasedBlockingQ;
    private final GenericStatsMetricPublisher genericStatsMetricPublisher;

    S3BlobStore(S3Service service, S3AsyncService s3AsyncService, boolean multipartUploadEnabled, String bucket, ByteSizeValue bufferSize, String cannedACL, String storageClass, int bulkDeletesSize, RepositoryMetadata repositoryMetadata, AsyncTransferManager asyncTransferManager, AsyncExecutorContainer urgentExecutorBuilder, AsyncExecutorContainer priorityExecutorBuilder, AsyncExecutorContainer normalExecutorBuilder, SizeBasedBlockingQ normalPrioritySizeBasedBlockingQ, SizeBasedBlockingQ lowPrioritySizeBasedBlockingQ, GenericStatsMetricPublisher genericStatsMetricPublisher, String serverSideEncryptionType, String serverSideEncryptionKmsKey, boolean serverSideEncryptionBucketKey, String serverSideEncryptionEncryptionContext, String expectedBucketOwner) {
        this.service = service;
        this.s3AsyncService = s3AsyncService;
        this.multipartUploadEnabled = multipartUploadEnabled;
        this.bucket = bucket;
        this.bufferSize = bufferSize;
        this.cannedACL = S3BlobStore.initCannedACL(cannedACL);
        this.storageClass = S3BlobStore.initStorageClass(storageClass);
        this.bulkDeletesSize = bulkDeletesSize;
        this.repositoryMetadata = repositoryMetadata;
        this.asyncTransferManager = asyncTransferManager;
        this.normalExecutorBuilder = normalExecutorBuilder;
        this.priorityExecutorBuilder = priorityExecutorBuilder;
        this.urgentExecutorBuilder = urgentExecutorBuilder;
        this.redirectLargeUploads = (Boolean)S3Repository.REDIRECT_LARGE_S3_UPLOAD.get(repositoryMetadata.settings());
        this.uploadRetryEnabled = (Boolean)S3Repository.UPLOAD_RETRY_ENABLED.get(repositoryMetadata.settings());
        this.normalPrioritySizeBasedBlockingQ = normalPrioritySizeBasedBlockingQ;
        this.lowPrioritySizeBasedBlockingQ = lowPrioritySizeBasedBlockingQ;
        this.genericStatsMetricPublisher = genericStatsMetricPublisher;
        this.permitBackedTransferEnabled = (Boolean)S3Repository.PERMIT_BACKED_TRANSFER_ENABLED.get(repositoryMetadata.settings());
        this.serverSideEncryptionType = serverSideEncryptionType;
        this.serverSideEncryptionKmsKey = serverSideEncryptionKmsKey;
        this.serverSideEncryptionBucketKey = serverSideEncryptionBucketKey;
        this.serverSideEncryptionEncryptionContext = serverSideEncryptionEncryptionContext;
        this.expectedBucketOwner = expectedBucketOwner;
    }

    public void reload(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
        this.bucket = (String)S3Repository.BUCKET_SETTING.get(repositoryMetadata.settings());
        this.bufferSize = (ByteSizeValue)S3Repository.BUFFER_SIZE_SETTING.get(repositoryMetadata.settings());
        this.cannedACL = S3BlobStore.initCannedACL((String)S3Repository.CANNED_ACL_SETTING.get(repositoryMetadata.settings()));
        this.storageClass = S3BlobStore.initStorageClass((String)S3Repository.STORAGE_CLASS_SETTING.get(repositoryMetadata.settings()));
        this.bulkDeletesSize = (Integer)S3Repository.BULK_DELETE_SIZE.get(repositoryMetadata.settings());
        this.redirectLargeUploads = (Boolean)S3Repository.REDIRECT_LARGE_S3_UPLOAD.get(repositoryMetadata.settings());
        this.uploadRetryEnabled = (Boolean)S3Repository.UPLOAD_RETRY_ENABLED.get(repositoryMetadata.settings());
        this.permitBackedTransferEnabled = (Boolean)S3Repository.PERMIT_BACKED_TRANSFER_ENABLED.get(repositoryMetadata.settings());
        this.serverSideEncryptionType = (String)S3Repository.SERVER_SIDE_ENCRYPTION_TYPE_SETTING.get(repositoryMetadata.settings());
        this.serverSideEncryptionKmsKey = (String)S3Repository.SERVER_SIDE_ENCRYPTION_KMS_KEY_SETTING.get(repositoryMetadata.settings());
        this.serverSideEncryptionBucketKey = (Boolean)S3Repository.SERVER_SIDE_ENCRYPTION_BUCKET_KEY_SETTING.get(repositoryMetadata.settings());
        this.serverSideEncryptionEncryptionContext = (String)S3Repository.SERVER_SIDE_ENCRYPTION_ENCRYPTION_CONTEXT_SETTING.get(repositoryMetadata.settings());
        this.expectedBucketOwner = (String)S3Repository.EXPECTED_BUCKET_OWNER_SETTING.get(repositoryMetadata.settings());
    }

    public String toString() {
        return this.bucket;
    }

    public AmazonS3Reference clientReference() {
        return this.service.client(this.repositoryMetadata);
    }

    public AmazonAsyncS3Reference asyncClientReference() {
        return this.s3AsyncService.client(this.repositoryMetadata, this.urgentExecutorBuilder, this.priorityExecutorBuilder, this.normalExecutorBuilder);
    }

    int getMaxRetries() {
        return this.service.settings((RepositoryMetadata)this.repositoryMetadata).maxRetries;
    }

    public boolean isRedirectLargeUploads() {
        return this.redirectLargeUploads;
    }

    public boolean isUploadRetryEnabled() {
        return this.uploadRetryEnabled;
    }

    public boolean isPermitBackedTransferEnabled() {
        return this.permitBackedTransferEnabled;
    }

    public String bucket() {
        return this.bucket;
    }

    public String serverSideEncryptionType() {
        return this.serverSideEncryptionType;
    }

    public String serverSideEncryptionKmsKey() {
        return this.serverSideEncryptionKmsKey;
    }

    public boolean serverSideEncryptionBucketKey() {
        return this.serverSideEncryptionBucketKey;
    }

    public String serverSideEncryptionEncryptionContext() {
        return this.serverSideEncryptionEncryptionContext == null || this.serverSideEncryptionEncryptionContext.isEmpty() ? null : Base64.getEncoder().encodeToString(this.serverSideEncryptionEncryptionContext.getBytes(StandardCharsets.UTF_8));
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner == null || this.expectedBucketOwner.isEmpty() ? null : this.expectedBucketOwner;
    }

    public long bufferSizeInBytes() {
        return this.bufferSize.getBytes();
    }

    public int getBulkDeletesSize() {
        return this.bulkDeletesSize;
    }

    public SizeBasedBlockingQ getNormalPrioritySizeBasedBlockingQ() {
        return this.normalPrioritySizeBasedBlockingQ;
    }

    public SizeBasedBlockingQ getLowPrioritySizeBasedBlockingQ() {
        return this.lowPrioritySizeBasedBlockingQ;
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new S3BlobContainer(path, this);
    }

    public void close() throws IOException {
        if (this.service != null) {
            this.service.close();
        }
        if (this.s3AsyncService != null) {
            this.s3AsyncService.close();
        }
    }

    public Map<String, Long> stats() {
        Map<String, Long> stats = this.statsMetricPublisher.getStats().toMap();
        stats.putAll(this.genericStatsMetricPublisher.stats());
        return stats;
    }

    public Map<BlobStore.Metric, Map<String, Long>> extendedStats() {
        if (this.statsMetricPublisher.getExtendedStats() == null || this.statsMetricPublisher.getExtendedStats().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<BlobStore.Metric, Map<String, Long>> extendedStats = new HashMap<BlobStore.Metric, Map<String, Long>>();
        this.statsMetricPublisher.getExtendedStats().forEach((k, v) -> extendedStats.put((BlobStore.Metric)k, v.toMap()));
        extendedStats.put(BlobStore.Metric.GENERIC_STATS, this.genericStatsMetricPublisher.stats());
        return extendedStats;
    }

    public boolean isBlobMetadataEnabled() {
        return true;
    }

    public ObjectCannedACL getCannedACL() {
        return this.cannedACL;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public StatsMetricPublisher getStatsMetricPublisher() {
        return this.statsMetricPublisher;
    }

    public static StorageClass initStorageClass(String storageClassStringValue) {
        if (storageClassStringValue == null || storageClassStringValue.equals("")) {
            return StorageClass.STANDARD;
        }
        StorageClass storageClass = StorageClass.fromValue((String)storageClassStringValue.toUpperCase(Locale.ENGLISH));
        if (storageClass.equals((Object)StorageClass.GLACIER)) {
            throw new BlobStoreException("Glacier storage class is not supported");
        }
        if (storageClass == StorageClass.UNKNOWN_TO_SDK_VERSION) {
            throw new BlobStoreException("`" + storageClassStringValue + "` is not a valid S3 Storage Class.");
        }
        return storageClass;
    }

    public static ObjectCannedACL initCannedACL(String cannedACL) {
        if (cannedACL == null || cannedACL.equals("")) {
            return ObjectCannedACL.PRIVATE;
        }
        for (ObjectCannedACL cur : ObjectCannedACL.values()) {
            if (!cur.toString().equalsIgnoreCase(cannedACL)) continue;
            return cur;
        }
        throw new BlobStoreException("cannedACL is not valid: [" + cannedACL + "]");
    }

    public AsyncTransferManager getAsyncTransferManager() {
        return this.asyncTransferManager;
    }
}

