/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class Bib2GlsDualIndexSymbol
extends Bib2GlsDualEntry {
    private String category;

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualindexsymbol", "symbol");
    }

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls, String string) {
        this(bib2Gls, string, "symbol");
    }

    public Bib2GlsDualIndexSymbol(Bib2Gls bib2Gls, String string, String string2) {
        super(bib2Gls, string);
        this.category = string2;
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualIndexSymbolMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualIndexSymbolMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualIndexSymbolMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualIndexSymbol(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("symbol") == null) {
            this.missingFieldWarning("symbol");
        }
    }

    @Override
    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.getOriginalEntryType());
        if (string != null) {
            return string;
        }
        return this.isPrimary() ? "name" : this.resource.getSymbolDefaultSortField();
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        if (string.equals("name")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("name") && this.bib2gls.useInterpreter()) {
            return this.getIdField();
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "";
        Set<String> set = this.getFieldSet();
        Vector<String> vector = this.resource.getOmitFieldList(this);
        for (String string7 : set) {
            if (vector != null && vector.contains(string7)) {
                this.bib2gls.verboseMessage("message.omitting.field", string7, this.getId());
                continue;
            }
            if (string7.equals("description")) {
                string2 = this.getFieldValue(string7);
                continue;
            }
            if (string7.equals("name")) {
                string3 = this.getFieldValue(string7);
                continue;
            }
            if (string7.equals("symbol")) {
                string6 = this.getFieldValue(string7);
                continue;
            }
            if (this.bib2gls.isKnownField(string7)) {
                String string8 = this.getFieldValue(string7);
                if (string7.equals("parent")) {
                    string4 = string8;
                } else if (string7.equals("plural")) {
                    string5 = string8;
                }
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string7, string8);
                continue;
            }
            if (!this.bib2gls.isDebuggingOn() || this.bib2gls.isInternalField(string7) || this.bib2gls.isKnownSpecialField(string7)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string7);
        }
        if (string3 == null) {
            string3 = this.getFallbackValue("name");
            this.writePluralIfInherited(printWriter, string3, string4, string5, string);
        }
        printWriter.println(String.format("}%%%n{%s}{%s}%n{%s}", string3, string6, string2));
        this.writeInternalFields(printWriter);
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[5]{%%%n", this.getCsName());
        printWriter.print("  \\longnewglossaryentry*{#1}{name={#3},");
        if (this.isPrimary()) {
            printWriter.println("category={index},");
        } else {
            printWriter.format("category={%s},", this.category);
        }
        printWriter.println("symbol={#4},#2}{#5}%");
        printWriter.println("}");
    }
}

