/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.wizards.product.BaseProductCreationOperation;

public class ProductFromExtensionOperation
extends BaseProductCreationOperation {
    private String fId;

    public ProductFromExtensionOperation(IFile file, String productId) {
        super(file);
        this.fId = productId;
    }

    @Override
    protected void initializeProduct(IProduct product) {
        if (this.fId == null) {
            return;
        }
        IProductModelFactory factory = product.getModel().getFactory();
        this.initializeProductInfo(factory, product, this.fId);
        this.addPlugins(factory, product, this.getPlugins());
        super.initializeProduct(product);
    }

    private String[] getPlugins() {
        String appId;
        IPluginAttribute attr;
        IPluginElement element;
        int lastDot = this.fId.lastIndexOf(46);
        if (lastDot == -1) {
            return new String[0];
        }
        ArrayList<BundleDescription> plugins = new ArrayList<BundleDescription>();
        IPluginModelBase model = PluginRegistry.findModel((String)this.fId.substring(0, lastDot));
        if (model != null) {
            plugins.add(model.getBundleDescription());
        }
        if ((element = this.getProductExtension(this.fId)) != null && (attr = element.getAttribute("application")) != null && (lastDot = (appId = attr.getValue()).lastIndexOf(46)) != -1 && (model = PluginRegistry.findModel((String)appId.substring(0, lastDot))) != null) {
            plugins.add(model.getBundleDescription());
        }
        Set bundles = DependencyManager.findRequirementsClosure(plugins, (boolean)false);
        return (String[])bundles.stream().map(BundleDescription::getSymbolicName).toArray(String[]::new);
    }
}

