/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.render;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;

public abstract class Renderer<T extends UIComponent> {
    public static final String PASSTHROUGH_RENDERER_LOCALNAME_KEY = "elementName";

    public void decode(FacesContext context, T component) {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public void encodeBegin(FacesContext context, T component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public void encodeChildren(FacesContext context, T component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (((UIComponent)component).getChildCount() > 0) {
            for (UIComponent kid : ((UIComponent)component).getChildren()) {
                kid.encodeAll(context);
            }
        }
    }

    public void encodeEnd(FacesContext context, T component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public String convertClientId(FacesContext context, String clientId) {
        if (context == null || clientId == null) {
            throw new NullPointerException();
        }
        return clientId;
    }

    public boolean getRendersChildren() {
        return false;
    }

    public Object getConvertedValue(FacesContext context, T component, Object submittedValue) throws ConverterException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        return submittedValue;
    }
}

