/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.ee.J2EESecurityManager;
import com.sun.enterprise.security.ee.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.ee.jmac.ConfigDomainParser;
import com.sun.enterprise.security.ee.jmac.WebServicesDelegate;
import com.sun.logging.LogDomains;
import jakarta.inject.Singleton;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.epicyro.config.factory.file.AuthConfigFileFactory;
import org.glassfish.epicyro.config.module.configprovider.GFServerConfigProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.Globals;
import org.glassfish.main.jdke.props.SystemProperties;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JavaEESecurityLifecycle
implements ContainerSecurityLifecycle,
PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(JavaEESecurityLifecycle.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);

    public void postConstruct() {
        this.onInitialization();
    }

    public void onInitialization() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !J2EESecurityManager.class.equals(securityManager.getClass())) {
            try {
                System.setSecurityManager(new J2EESecurityManager());
            }
            catch (SecurityException ex) {
                LOG.log(Level.WARNING, "Could not override SecurityManager");
            }
        }
        this.initializeJakartaAuthentication();
    }

    private void initializeJakartaAuthentication() {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", AuthConfigFileFactory.class.getName());
        }
        Object defaultProvidersString = null;
        WebServicesDelegate delegate = (WebServicesDelegate)Globals.get(WebServicesDelegate.class);
        defaultProvidersString = delegate == null ? GFServerConfigProvider.class.getName() : delegate.getDefaultWebServicesProvider() + " " + GFServerConfigProvider.class.getName();
        Security.setProperty("authconfigprovider.factory.providers", (String)defaultProvidersString);
        Function<MessageInfo, String> authContextIdGenerator = e -> ((WebServicesDelegate)Globals.get(WebServicesDelegate.class)).getAuthContextID((MessageInfo)e);
        BiFunction<String, Map, MessagePolicy[]> soapPolicyGenerator = (authContextId, properties) -> AuthMessagePolicy.getSOAPPolicies(AuthMessagePolicy.getMessageSecurityBinding("SOAP", properties), authContextId, true);
        Provider provider = new Provider("EleosProvider", "1.0", ""){
            private static final long serialVersionUID = 1L;
        };
        provider.put("authContextIdGenerator", authContextIdGenerator);
        provider.put("soapPolicyGenerator", soapPolicyGenerator);
        Security.addProvider(provider);
        SystemProperties.setProperty((String)"config.parser", (String)ConfigDomainParser.class.getName(), (boolean)true);
    }
}

