/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx.elements;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinarySecretImpl;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntropyImpl
extends EntropyType
implements Entropy {
    private String entropyType;
    private static final QName _EntropyType_QNAME = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Type");
    private BinarySecret binarySecret = null;
    private EncryptedKey encryptedKey = null;

    public EntropyImpl() {
    }

    public EntropyImpl(BinarySecret binarySecret) {
        this.setBinarySecret(binarySecret);
    }

    public EntropyImpl(EncryptedKey encryptedKey) {
        this.setEncryptedKey(encryptedKey);
    }

    public EntropyImpl(EntropyType etype) {
        this.entropyType = etype.getOtherAttributes().get(_EntropyType_QNAME);
        List<Object> list = etype.getAny();
        for (int i = 0; i < list.size(); ++i) {
            JAXBElement obj = (JAXBElement)list.get(i);
            String local = obj.getName().getLocalPart();
            if (!local.equalsIgnoreCase("BinarySecret")) continue;
            BinarySecretType bst = (BinarySecretType)obj.getValue();
            this.setBinarySecret(new BinarySecretImpl(bst));
        }
    }

    public static EntropyType fromElement(Element element) throws WSTrustException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.xml.ws.security.trust.impl.elements");
            Unmarshaller u = jc.createUnmarshaller();
            return (EntropyType)u.unmarshal((Node)element);
        }
        catch (Exception ex) {
            throw new WSTrustException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getEntropyType() {
        return this.entropyType;
    }

    @Override
    public void setEntropyType(String type) {
        if (!(type.equalsIgnoreCase("BinarySecret") || type.equalsIgnoreCase("Custom") || type.equalsIgnoreCase("EncryptedKey"))) {
            throw new RuntimeException("Invalid Entropy Type");
        }
        this.entropyType = type;
        this.getOtherAttributes().put(_EntropyType_QNAME, type);
    }

    @Override
    public BinarySecret getBinarySecret() {
        return this.binarySecret;
    }

    @Override
    public void setBinarySecret(BinarySecret binarySecret) {
        if (binarySecret != null) {
            this.binarySecret = binarySecret;
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)binarySecret));
            this.getAny().add(bsElement);
        }
    }

    @Override
    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    @Override
    public void setEncryptedKey(EncryptedKey encryptedKey) {
        if (encryptedKey != null) {
            this.encryptedKey = encryptedKey;
            this.getAny().add(encryptedKey);
        }
    }
}

