/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.domain.DomainTemplate;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.DomainInfo;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.ObjectFactory;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.TemplateRef;
import com.sun.enterprise.admin.servermgmt.xml.templateinfo.TemplateInfo;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.embeddable.GlassFishVariable;

public class DomainInfoManager {
    private static final Logger _logger = SLogger.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DomainTemplate domainTemplate, File domainDir) {
        FileOutputStream outputStream = null;
        try {
            TemplateInfo templateInfo = domainTemplate.getInfo();
            File infoDir = new File(domainDir, "init-info");
            if (!infoDir.exists() && !infoDir.mkdirs()) {
                _logger.log(Level.INFO, "NCLS-SRVRMGMT-00011", infoDir.getAbsolutePath());
                return;
            }
            File domainInfoXML = new File(infoDir, "domain-info.xml");
            outputStream = new FileOutputStream(domainInfoXML);
            ObjectFactory objFactory = new ObjectFactory();
            DomainInfo domainInfo = objFactory.createDomainInfo();
            String javaHome = System.getenv(GlassFishVariable.JAVA_HOME.getEnvName());
            if (javaHome == null || javaHome.isEmpty()) {
                javaHome = System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName());
            }
            domainInfo.setJavahome(javaHome);
            domainInfo.setMwhome(System.getProperty(GlassFishVariable.PRODUCT_ROOT.getPropertyName()));
            TemplateRef templateRef = new TemplateRef();
            templateRef.setName(templateInfo.getName());
            templateRef.setVersion(templateInfo.getVersion());
            templateRef.setLocation(domainTemplate.getLocation());
            domainInfo.setDomainTemplateRef(templateRef);
            JAXBContext context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(objFactory.createDomainInfo(domainInfo), (OutputStream)outputStream);
        }
        catch (Exception e) {
            LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"NCLS-SRVRMGMT-00012", (Throwable)e, (Object[])new Object[]{"domain-info.xml"});
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

