/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.api.enabler;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.main.jdke.props.SystemProperties;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class ORBConnectorStartup
implements PostConstruct {
    private static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    private static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    private static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    private static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    private static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    private static final String ORB_CLASS = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_CLASS = "com.sun.corba.se.impl.orb.ORBImpl";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private GrizzlyService grizzlyService;

    public void postConstruct() {
        this.setORBSystemProperties();
        this.initializeLazyListener();
    }

    private void setORBSystemProperties() {
        SystemProperties.setProperty((String)OMG_ORB_CLASS_PROPERTY, (String)ORB_CLASS, (boolean)false);
        SystemProperties.setProperty((String)OMG_ORB_SINGLETON_CLASS_PROPERTY, (String)ORB_SINGLETON_CLASS, (boolean)false);
        SystemProperties.setProperty((String)ORB_UTIL_CLASS_PROPERTY, (String)RMI_UTIL_CLASS, (boolean)true);
        SystemProperties.setProperty((String)RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, (String)RMI_STUB_CLASS, (boolean)true);
        SystemProperties.setProperty((String)RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, (String)RMI_PRO_CLASS, (boolean)true);
    }

    private void initializeLazyListener() {
        IiopService iiopService = (IiopService)this.config.getExtensionByType(IiopService.class);
        if (iiopService != null) {
            List<IiopListener> iiopListenerList = iiopService.getIiopListener();
            for (IiopListener oneListener : iiopListenerList) {
                if (!Boolean.valueOf(oneListener.getEnabled()).booleanValue() || !Boolean.valueOf(oneListener.getLazyInit()).booleanValue()) continue;
                DummyNetworkListener dummy = new DummyNetworkListener();
                dummy.setPort(oneListener.getPort());
                dummy.setAddress(oneListener.getAddress());
                dummy.setProtocol("light-weight-listener");
                dummy.setTransport("tcp");
                dummy.setName("iiop-service");
                this.grizzlyService.createNetworkProxy((NetworkListener)dummy);
            }
        }
    }
}

