/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.innate.spi.EntityPartBuilderProvider;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.glassfish.jersey.media.multipart.internal.l10n.LocalizationMessages;

public class JerseyEntityPartBuilderProvider
implements EntityPartBuilderProvider {
    public EntityPart.Builder withName(String partName) {
        return new EnityPartBuilder().withName(partName);
    }

    private static class EnityPartBuilder
    implements EntityPart.Builder {
        private String partName;
        private String fileName = null;
        private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
        private MediaType mediaType = null;
        private MethodData methodData;

        private EnityPartBuilder() {
        }

        private EntityPart.Builder withName(String partName) {
            this.partName = partName;
            return this;
        }

        public EntityPart.Builder mediaType(MediaType mediaType) throws IllegalArgumentException {
            this.mediaType = mediaType;
            return this;
        }

        public EntityPart.Builder mediaType(String mediaTypeString) throws IllegalArgumentException {
            this.mediaType = MediaType.valueOf((String)mediaTypeString);
            return this;
        }

        public EntityPart.Builder header(String headerName, String ... headerValues) throws IllegalArgumentException {
            this.headers.addAll((Object)headerName, (Object[])headerValues);
            return this;
        }

        public EntityPart.Builder headers(MultivaluedMap<String, String> newHeaders) throws IllegalArgumentException {
            for (Map.Entry entry : newHeaders.entrySet()) {
                this.header((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
            }
            return this;
        }

        public EntityPart.Builder fileName(String fileName) throws IllegalArgumentException {
            this.fileName = fileName;
            return this;
        }

        public EntityPart.Builder content(InputStream content) throws IllegalArgumentException {
            this.methodData = new InputStreamMethodData(content);
            return this;
        }

        public <T> EntityPart.Builder content(T content, Class<? extends T> type) throws IllegalArgumentException {
            this.methodData = File.class.equals(type) ? new FileMethodData((File)content) : (InputStream.class.equals(type) ? new InputStreamMethodData((InputStream)content) : new GenericData(content, null));
            return this;
        }

        public <T> EntityPart.Builder content(T content, GenericType<T> type) throws IllegalArgumentException {
            this.methodData = File.class.equals((Object)type.getRawType()) ? new FileMethodData((File)content) : (InputStream.class.equals((Object)type.getRawType()) ? new InputStreamMethodData((InputStream)content) : new GenericData(content, type));
            return this;
        }

        public EntityPart build() throws IllegalStateException, IOException, WebApplicationException {
            if (this.methodData == null) {
                throw new IllegalStateException(LocalizationMessages.ENTITY_CONTENT_NOT_SET());
            }
            FormDataBodyPart bodyPart = this.methodData.build();
            return bodyPart;
        }

        private class InputStreamMethodData
        extends MethodData<InputStream> {
            protected InputStreamMethodData(InputStream content) {
                super(content);
            }

            @Override
            protected FormDataBodyPart build() {
                StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart();
                streamDataBodyPart.setFilename(EnityPartBuilder.this.fileName);
                this.fillFormData(streamDataBodyPart);
                streamDataBodyPart.setStreamEntity((InputStream)this.content, EnityPartBuilder.this.mediaType);
                return streamDataBodyPart;
            }
        }

        private abstract class MethodData<T> {
            protected final T content;

            protected MethodData(T content) {
                this.content = content;
            }

            protected abstract FormDataBodyPart build();

            protected void fillFormData(FormDataBodyPart bodyPart) {
                FormDataContentDisposition contentDisposition = ((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name(EnityPartBuilder.this.partName).fileName(EnityPartBuilder.this.fileName)).build();
                bodyPart.setContentDisposition(contentDisposition);
                if (EnityPartBuilder.this.mediaType != null) {
                    bodyPart.setMediaType(EnityPartBuilder.this.mediaType);
                }
                for (Map.Entry entry : EnityPartBuilder.this.headers.entrySet()) {
                    bodyPart.getHeaders().addAll((Object)((String)entry.getKey()), (Object[])((List)entry.getValue()).toArray(new String[0]));
                }
            }
        }

        private class FileMethodData
        extends MethodData<File> {
            protected FileMethodData(File content) {
                super(content);
            }

            @Override
            protected FormDataBodyPart build() {
                FileDataBodyPart fileDataBodyPart = new FileDataBodyPart();
                this.fillFormData(fileDataBodyPart);
                if (EnityPartBuilder.this.mediaType != null) {
                    fileDataBodyPart.setFileEntity((File)this.content, EnityPartBuilder.this.mediaType);
                } else {
                    fileDataBodyPart.setFileEntity((File)this.content);
                }
                return fileDataBodyPart;
            }
        }

        private class GenericData
        extends MethodData<Object> {
            private final GenericType<?> genericEntity;

            protected GenericData(Object content, GenericType<?> genericEntity) {
                super(content);
                this.genericEntity = genericEntity;
            }

            @Override
            protected FormDataBodyPart build() {
                FormDataBodyPart formDataBodyPart = new FormDataBodyPart();
                this.fillFormData(formDataBodyPart);
                if (this.genericEntity != null && !GenericEntity.class.isInstance(this.content)) {
                    GenericEntity entity = new GenericEntity(this.content, this.genericEntity.getType());
                    formDataBodyPart.setEntity(entity);
                } else {
                    formDataBodyPart.setEntity(this.content);
                }
                return formDataBodyPart;
            }
        }
    }
}

