/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;

public final class RemoteInstanceCommandHelper {
    private final List<Server> servers;
    private final ServiceLocator habitat;

    public RemoteInstanceCommandHelper(ServiceLocator habitatIn) {
        try {
            this.habitat = habitatIn;
            this.servers = ((Servers)this.habitat.getService(Servers.class, new Annotation[0])).getServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String getHost(String serverName) {
        String host = null;
        Server server = this.getServer(serverName);
        if (server != null) {
            host = server.getAdminHost();
        }
        return host;
    }

    public final Server getServer(String serverName) {
        for (Server server : this.servers) {
            String name = server.getName();
            if (!(serverName == null ? name == null : serverName.equals(name))) continue;
            return server;
        }
        return null;
    }

    public final String getNode(Server server) {
        if (server == null) {
            return null;
        }
        String node = server.getNodeRef();
        return StringUtils.ok((String)node) ? node : "no node";
    }

    public final int getAdminPort(String serverName) {
        return this.getAdminPort(this.getServer(serverName));
    }

    public final int getAdminPort(Server server) {
        return server.getAdminPort();
    }
}

