/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.annotation.FacesComponentUsage;
import com.sun.faces.facelets.tag.faces.LazyTagLibrary;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.util.List;

public class FacesComponentTagLibrary
extends LazyTagLibrary {
    private ApplicationAssociate appAss;

    public FacesComponentTagLibrary(String ns) {
        super(ns);
        if (null == ns) {
            throw new NullPointerException();
        }
        this.appAss = ApplicationAssociate.getCurrentInstance();
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        Util.notNull("namespace", ns);
        Util.notNull("tagName", localName);
        if (!ns.equals(this.getNamespace())) {
            return false;
        }
        boolean containsTagHandler = super.containsTagHandler(ns, localName);
        if (!containsTagHandler) {
            FacesComponentUsage matchingFacesComponentUsage = this.findFacesComponentUsageForLocalName(ns, localName);
            containsTagHandler = null != matchingFacesComponentUsage;
        }
        return containsTagHandler;
    }

    private FacesComponentUsage findFacesComponentUsageForLocalName(String ns, String localName) {
        FacesComponentUsage result = null;
        Util.notNull("namespace", ns);
        Util.notNull("tagName", localName);
        if (!ns.equals(this.getNamespace())) {
            return result;
        }
        List<FacesComponentUsage> componentsForNamespace = this.appAss.getComponentsForNamespace(ns);
        for (FacesComponentUsage cur : componentsForNamespace) {
            FacesComponent curFacesComponent = cur.getAnnotation();
            Object tagName = curFacesComponent.tagName();
            if (null != tagName && 0 < ((String)tagName).length()) {
                if (!localName.equals(tagName)) continue;
                result = cur;
                break;
            }
            if (null == tagName) continue;
            tagName = cur.getTarget().getSimpleName();
            if (!localName.equals(tagName = ((String)tagName).substring(0, 1).toLowerCase() + ((String)tagName).substring(1))) continue;
            result = cur;
            break;
        }
        return result;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        assert (this.containsTagHandler(ns, localName));
        TagHandler result = super.createTagHandler(ns, localName, tag);
        if (null == result) {
            FacesComponentUsage facesComponentUsage = this.findFacesComponentUsageForLocalName(ns, localName);
            Object componentType = facesComponentUsage.getAnnotation().value();
            if (null == componentType || 0 == ((String)componentType).length()) {
                componentType = facesComponentUsage.getTarget().getSimpleName();
                componentType = Character.toLowerCase(((String)componentType).charAt(0)) + ((String)componentType).substring(1);
            }
            UIComponent throwAwayComponent = FacesContext.getCurrentInstance().getApplication().createComponent((String)componentType);
            String rendererType = throwAwayComponent.getRendererType();
            super.addComponent(localName, (String)componentType, rendererType);
            result = super.createTagHandler(ns, localName, tag);
        }
        return result;
    }

    @Override
    public boolean tagLibraryForNSExists(String ns) {
        boolean result = false;
        List<FacesComponentUsage> componentsForNamespace = this.appAss.getComponentsForNamespace(ns);
        result = !componentsForNamespace.isEmpty();
        return result;
    }
}

