/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EnvEntriesValidator {
    private static final String JAVA_COLON = "java:";
    private static final String JAVA_COMP_ENV_STRING = "java:comp/env/";
    private static final String JAVA_COMP_PREFIX = "java:comp/";
    private static final String JAVA_MODULE_PREFIX = "java:module/";
    private static final String JAVA_APP_PREFIX = "java:app/";
    private Map<String, Map> componentNamespaces = new HashMap<String, Map>();
    private Map<String, Map> appNamespaces = new HashMap<String, Map>();
    private Map<AppModuleKey, Map> moduleNamespaces = new HashMap<AppModuleKey, Map>();
    private Map globalNameSpace = new HashMap();

    public void validateEnvEntries(JndiNameEnvironment env) {
        if (env instanceof WebBundleDescriptor) {
            Enumeration<EnvironmentEntry> envEntries = ((WebBundleDescriptor)env).getEnvironmentEntries();
            this.validateSimpleEnvEntries(env, envEntries);
        } else {
            Set envProperties = env.getEnvironmentProperties();
            this.validateSimpleEnvEntries(env, envProperties);
        }
        Set ejbReferences = env.getEjbReferenceDescriptors();
        this.validateEjbReferences(env, ejbReferences);
        Set resRefs = env.getResourceReferenceDescriptors();
        this.validateResRefs(env, resRefs);
        Set resEnvRefs = env.getResourceEnvReferenceDescriptors();
        this.validateResEnvRefs(env, resEnvRefs);
    }

    private void validateSimpleEnvEntries(JndiNameEnvironment env, Set<EnvironmentProperty> envEntries) {
        for (EnvironmentProperty environmentProperty : envEntries) {
            SimpleEnvEntry simpleEnvEntry = new SimpleEnvEntry((EnvironmentEntry)environmentProperty);
            this.validateEnvEntry(env, simpleEnvEntry, simpleEnvEntry.getName());
        }
    }

    private void validateSimpleEnvEntries(JndiNameEnvironment env, Enumeration<EnvironmentEntry> envEntries) {
        while (envEntries.hasMoreElements()) {
            EnvironmentEntry envEntry = envEntries.nextElement();
            SimpleEnvEntry simpleEnvEntry = new SimpleEnvEntry(envEntry);
            this.validateEnvEntry(env, simpleEnvEntry, simpleEnvEntry.getName());
        }
    }

    private void validateEjbReferences(JndiNameEnvironment env, Set<EjbReference> ejbRefes) {
        for (EjbReference ejbRef : ejbRefes) {
            this.validateEnvEntry(env, ejbRef, ejbRef.getName());
        }
    }

    private void validateResRefs(JndiNameEnvironment env, Set<ResourceReferenceDescriptor> resRefs) {
        for (ResourceReferenceDescriptor resRef : resRefs) {
            this.validateEnvEntry(env, resRef, resRef.getName());
        }
    }

    private void validateResEnvRefs(JndiNameEnvironment env, Set<ResourceEnvReferenceDescriptor> resEnvRefs) {
        for (ResourceEnvReferenceDescriptor resEnvRef : resEnvRefs) {
            this.validateEnvEntry(env, resEnvRef, resEnvRef.getName());
        }
    }

    private void validateEnvEntry(JndiNameEnvironment env, Object curEntry, String name) {
        String logicalJndiName = this.getLogicalJNDIName(name, env);
        Map namespace = this.getNamespace(logicalJndiName, env);
        Object preObject = namespace.get(logicalJndiName);
        if (preObject != null) {
            if (preObject instanceof SimpleEnvEntry && curEntry instanceof SimpleEnvEntry) {
                SimpleEnvEntry preEnvEntry = (SimpleEnvEntry)preObject;
                SimpleEnvEntry curEnvEntry = (SimpleEnvEntry)curEntry;
                if (this.areConflicting(preEnvEntry.getType(), curEnvEntry.getType()) || this.areConflicting(preEnvEntry.getValue(), curEnvEntry.getValue())) {
                    this.throwConflictException(name, namespace.toString());
                }
            } else if (preObject instanceof EjbReference && curEntry instanceof EjbReference) {
                EjbReference preRef = (EjbReference)preObject;
                EjbReference curRef = (EjbReference)curEntry;
                if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getEjbHomeInterface(), curRef.getEjbHomeInterface()) || this.areConflicting(preRef.getEjbInterface(), curRef.getEjbInterface()) || preRef.getLinkName() != null && curRef.getLinkName() != null && !preRef.getLinkName().equals(curRef.getLinkName()) || preRef.isLocal() != curRef.isLocal() || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                    this.throwConflictException(name, namespace.toString());
                }
            } else if (preObject instanceof ResourceReferenceDescriptor && curEntry instanceof ResourceReferenceDescriptor) {
                ResourceReferenceDescriptor preRef = (ResourceReferenceDescriptor)preObject;
                ResourceReferenceDescriptor curRef = (ResourceReferenceDescriptor)curEntry;
                if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getAuthorization(), curRef.getAuthorization()) || this.areConflicting(preRef.getSharingScope(), curRef.getSharingScope()) || this.areConflicting(preRef.getMappedName(), curRef.getMappedName()) || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                    this.throwConflictException(name, namespace.toString());
                }
            } else if (preObject instanceof ResourceEnvReferenceDescriptor && curEntry instanceof ResourceEnvReferenceDescriptor) {
                ResourceEnvReferenceDescriptor preRef = (ResourceEnvReferenceDescriptor)preObject;
                ResourceEnvReferenceDescriptor curRef = (ResourceEnvReferenceDescriptor)curEntry;
                if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getRefType(), curRef.getRefType()) || this.areConflicting(preRef.getMappedName(), curRef.getMappedName()) || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                    this.throwConflictException(name, namespace.toString());
                }
            } else {
                this.throwConflictException(name, namespace.toString());
            }
        } else {
            namespace.put(logicalJndiName, curEntry);
        }
    }

    private Map getNamespace(String logicalJndiName, JndiNameEnvironment env) {
        String appName = DOLUtils.getApplicationName(env);
        Map namespace = null;
        if (logicalJndiName.startsWith(JAVA_COMP_PREFIX)) {
            String componentId = DOLUtils.getComponentEnvId(env);
            namespace = this.componentNamespaces.get(componentId);
            if (namespace == null) {
                namespace = new HashMap();
                this.componentNamespaces.put(componentId, namespace);
            }
        } else if (logicalJndiName.startsWith(JAVA_MODULE_PREFIX)) {
            String moduleName = DOLUtils.getModuleName(env);
            AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
            namespace = this.moduleNamespaces.get(appModuleKey);
            if (namespace == null) {
                namespace = new HashMap();
                this.moduleNamespaces.put(appModuleKey, namespace);
            }
        } else if (logicalJndiName.startsWith(JAVA_APP_PREFIX)) {
            namespace = this.appNamespaces.get(appName);
            if (namespace == null) {
                namespace = new HashMap();
                this.appNamespaces.put(appName, namespace);
            }
        } else {
            namespace = this.globalNameSpace;
        }
        return namespace;
    }

    private void throwConflictException(String jndiName, String namespace) {
        throw new IllegalStateException("Naming binding already exists for " + jndiName + " in namespace " + namespace);
    }

    private boolean areConflicting(String s1, String s2) {
        boolean conflict = false;
        if (s1 != null && !s1.equals(s2) || s2 != null && !s2.equals(s1)) {
            conflict = true;
        }
        return conflict;
    }

    private String rawNameToLogicalJndiName(String rawName) {
        return rawName.startsWith(JAVA_COLON) ? rawName : JAVA_COMP_ENV_STRING + rawName;
    }

    private String logicalCompJndiNameToModule(String logicalCompName) {
        String tail = logicalCompName.substring(JAVA_COMP_PREFIX.length());
        return JAVA_MODULE_PREFIX + tail;
    }

    private String getLogicalJNDIName(String name, JndiNameEnvironment env) {
        String logicalJndiName = this.rawNameToLogicalJndiName(name);
        boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule(env);
        if (treatComponentAsModule && logicalJndiName.startsWith(JAVA_COMP_PREFIX)) {
            logicalJndiName = this.logicalCompJndiNameToModule(logicalJndiName);
        }
        return logicalJndiName;
    }

    private static class SimpleEnvEntry
    extends EnvironmentProperty {
        SimpleEnvEntry(EnvironmentEntry envEntry) {
            super(envEntry.getName(), envEntry.getValue(), envEntry.getDescription(), envEntry.getType());
        }
    }

    private static class AppModuleKey {
        private String app;
        private String module;

        public AppModuleKey(String appName, String moduleName) {
            this.app = appName;
            this.module = moduleName;
        }

        public boolean equals(Object o) {
            boolean equal = false;
            if (o != null && o instanceof AppModuleKey) {
                AppModuleKey other = (AppModuleKey)o;
                if (this.app.equals(other.app) && this.module.equals(other.module)) {
                    equal = true;
                }
            }
            return equal;
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String toString() {
            return "appName = " + this.app + " , module = " + this.module;
        }
    }
}

