/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ResourceAdapterAssociation;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=AdministeredObject.class)
public class AdministeredObjectHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AdministeredObjectHandler.class);

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        AdministeredObject adminObject = (AdministeredObject)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            RarBundleContext rarContext = (RarBundleContext)aeHandler;
            ConnectorDescriptor desc = rarContext.getDescriptor();
            Class c = (Class)element.getAnnotatedElement();
            String adminObjectClassName = c.getName();
            Class[] adminObjectInterfaceClasses = adminObject.adminObjectInterfaces();
            if (adminObjectInterfaceClasses != null && adminObjectInterfaceClasses.length > 0) {
                for (Class adminObjectInterface : adminObjectInterfaceClasses) {
                    this.processAdminObjectInterface(adminObjectClassName, adminObjectInterface.getName(), desc);
                }
            } else {
                List<Class> interfacesList = AdministeredObjectHandler.deriveAdminObjectInterfacesFromHierarchy(c);
                if (interfacesList.size() == 1) {
                    Class intf = interfacesList.get(0);
                    String intfName = intf.getName();
                    this.processAdminObjectInterface(adminObjectClassName, intfName, desc);
                }
            }
        } else {
            this.getFailureResult(element, "not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    public static List<Class> deriveAdminObjectInterfacesFromHierarchy(Class c) {
        Class<?>[] interfaces = c.getInterfaces();
        ArrayList<Class> interfacesList = new ArrayList<Class>(Arrays.asList(interfaces));
        interfacesList.remove(Serializable.class);
        interfacesList.remove(Externalizable.class);
        interfacesList.remove(ResourceAdapterAssociation.class);
        return interfacesList;
    }

    private void processAdminObjectInterface(String adminObjectClassName, String adminObjectInterfaceName, ConnectorDescriptor desc) {
        Set ddAdminObjects = desc.getAdminObjects();
        boolean ignore = false;
        for (Object o : ddAdminObjects) {
            AdminObject ddAdminObject = (AdminObject)o;
            if (!ddAdminObject.getAdminObjectInterface().equals(adminObjectInterfaceName) || !ddAdminObject.getAdminObjectClass().equals(adminObjectClassName)) continue;
            ignore = true;
            break;
        }
        if (!ignore) {
            AdminObject ao = new AdminObject(adminObjectInterfaceName, adminObjectClassName);
            desc.addAdminObject(ao);
        } else if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Ignoring administered object annotation [ " + adminObjectInterfaceName + "," + adminObjectClassName + "] as it is already defined ");
        }
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

