/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.generate.Generator;
import com.sun.faces.generate.PropertyManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Stack;

public abstract class JspTLDGenerator
implements Generator {
    private static final String DEFAULT_BODY_CONTENT = "JSP";
    private static final String DEFAULT_RTEXPRVALUE = "false";
    protected XMLWriter writer;
    protected FacesConfigBean configBean;
    protected PropertyManager propManager;
    private String outputFile;

    public JspTLDGenerator(PropertyManager propManager) {
        this.propManager = propManager;
        File outputDir = new File(System.getProperty("user.dir") + File.separatorChar + propManager.getProperty("base.output.dir") + File.separatorChar + "conf" + File.separatorChar + "share");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        this.outputFile = outputDir.toString() + File.separatorChar + propManager.getProperty("taglib.file.name");
    }

    @Override
    public void generate(FacesConfigBean configBean) {
        this.configBean = configBean;
        try {
            this.initWriter();
            this.writeDocument();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void writeDocument() throws IOException {
        this.writeProlog();
        this.writeTldDescription();
        this.writeValidators();
        this.writeTags();
        this.endDocument();
    }

    protected void writeProlog() throws IOException {
        this.writer.writeProlog();
    }

    protected abstract void writeTldDescription() throws IOException;

    protected abstract void writeTags() throws IOException;

    protected void endDocument() throws IOException {
        this.writer.closeAllElements();
        this.writer.flush();
        this.writer.close();
    }

    protected void writeValidators() throws IOException {
        this.writer.writeComment("============== Tag Library Validator =============");
        this.writer.startElement("validator");
        this.writer.startElement("validator-class");
        this.writer.writeText("com.sun.faces.taglib.html_basic.HtmlBasicValidator");
        this.writer.closeElement(2);
    }

    protected void initWriter() throws IOException {
        this.writer = new XMLWriter(new FileOutputStream(this.outputFile));
    }

    protected String makeTldTagName(String componentFamily, String rendererType) {
        if (componentFamily == null) {
            return null;
        }
        if (rendererType.startsWith("resource.")) {
            rendererType = rendererType.split("\\.")[1];
        }
        String tagName = Character.toLowerCase(componentFamily.charAt(0)) + componentFamily.substring(1);
        if (rendererType == null || componentFamily.equals(rendererType)) {
            return tagName;
        }
        return tagName + rendererType;
    }

    protected boolean attributeShouldBeExcluded(RendererBean renderer, String attribute) {
        String excludedAttributes = renderer.getExcludeAttributes();
        boolean skip = false;
        if (excludedAttributes != null) {
            skip = attribute != null && excludedAttributes.indexOf(attribute) != -1;
        }
        return skip;
    }

    protected String getBodyContent(String tagName) {
        return DEFAULT_BODY_CONTENT;
    }

    protected String getRtexprvalue(String tagName, String attributeName) {
        return DEFAULT_RTEXPRVALUE;
    }

    protected String loadOptionalTags() throws IOException {
        String path = this.propManager.getProperty("taglib.include");
        if (path != null) {
            int ch;
            if (path.charAt(0) == '/' || path.charAt(1) == ':') {
                if (path.charAt(1) == ':') {
                    path = path.replace('/', File.separatorChar);
                }
            } else {
                path = System.getProperty("user.dir") + File.separatorChar + path;
                path = path.replace('/', File.separatorChar);
            }
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(path));
            while ((ch = reader.read()) >= 0) {
                sb.append((char)ch);
            }
            reader.close();
            return sb.toString();
        }
        return null;
    }

    protected static class XMLWriter
    extends OutputStreamWriter {
        private static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
        private static final String TAB = "    ";
        private static final int NUM_COMMENT_CHARS = 10;
        private static final String START_COMMENT = "\n<!-- ";
        private static final String END_COMMENT = " -->\n\n";
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private Stack<String> elementStack = new Stack();

        XMLWriter(OutputStream stream) {
            super(stream, UTF8);
        }

        public void writeProlog() throws IOException {
            super.write(XML_PROLOG);
        }

        public void writeText(String value) throws IOException {
            if (value == null) {
                value = "NULL VALUE";
            }
            StringBuffer sb = new StringBuffer();
            String[] tokens = value.split("\n");
            for (int i = 0; i < tokens.length; ++i) {
                String val = tokens[i].trim();
                int size = this.elementStack.size();
                for (int ii = 0; ii < size; ++ii) {
                    sb.append(TAB);
                }
                sb.append(val).append('\n');
            }
            super.write(sb.toString());
        }

        public void startElement(String name, Map<String, String> attributes) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException("Null element name");
            }
            StringBuffer sb = new StringBuffer();
            int size = this.elementStack.size();
            for (int i = 0; i < size; ++i) {
                sb.append(TAB);
            }
            this.elementStack.push(name);
            String attributesString = null;
            if (attributes != null) {
                attributesString = this.createAttributesString(attributes);
            }
            sb.append('<').append(name);
            if (attributesString != null) {
                sb.append(attributesString);
            }
            sb.append(">\n");
            super.write(sb.toString());
        }

        public void startElement(String name) throws IOException {
            this.startElement(name, null);
        }

        public void closeElement(int elementCount) throws IOException {
            if (this.elementStack.size() == 0) {
                throw new IllegalStateException("Cannot close element - no elements on stack");
            }
            StringBuffer sb = new StringBuffer();
            for (int count = 0; count < elementCount; ++count) {
                String elementName = this.elementStack.pop();
                int size = this.elementStack.size();
                for (int i = 0; i < size; ++i) {
                    sb.append(TAB);
                }
                sb.append("</").append(elementName).append(">\n");
            }
            super.write(sb.toString());
        }

        public void closeElement() throws IOException {
            this.closeElement(1);
        }

        public void closeAllElements() throws IOException {
            this.closeElement(this.elementStack.size());
        }

        public void writeComment(String value) throws IOException {
            StringBuffer sb = new StringBuffer(value.length() + 10);
            sb.append(START_COMMENT).append(value).append(END_COMMENT);
            super.write(sb.toString());
        }

        private String createAttributesString(Map<String, String> attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException("Null attributes map");
            }
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String name = entry.getKey();
                sb.append(' ').append(name).append('=');
                sb.append('\"').append(entry.getValue()).append('\"');
            }
            return sb.toString();
        }
    }
}

