/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._float.minexclusive.minexclusive_3;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive3_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive3_ValidateCTTests test = new minExclusive3_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final float[] validValues = {3385806.0000000000001E16F, 5204608.815243518342E16F
                                , Float.POSITIVE_INFINITY};
    
    final float[] invalidValues = {3385806E15F, 0.0F, - Float.MAX_VALUE
                                , Float.NEGATIVE_INFINITY, Float.NaN};
    
    JAXBElement<Float> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<Float>)unmarshal("minExclusive-3-1.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<Float>)unmarshal("minExclusive-3-1.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatMinExclusive3(1.0F);
        
        return testValid();
    }

    public Status Created002( ) {
        elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatMinExclusive3(1.0F);
        
        return testInvalid();
    }


}

