/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.bindings.internal.SyncedBindingHelperObserver;

public class SyncObjectBinding<A>
extends ObjectBinding<A> {
    private SyncedBindingHelperObserver observer;
    private ObservableValue<A> source;
    private ThreadSynchronize thread;

    public SyncObjectBinding(ObservableValue<A> source, ThreadSynchronize thread) {
        this.source = source;
        this.thread = thread;
        this.syncedBind(new Observable[]{this.source});
    }

    public void dispose() {
        this.syncedUnbind(new Observable[]{this.source});
        super.dispose();
    }

    protected A computeValue() {
        return (A)this.source.getValue();
    }

    protected final void syncedBind(Observable ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            if (this.observer == null) {
                this.observer = new SyncedBindingHelperObserver(this.thread, (Binding<?>)this);
            }
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable dep = observableArray[n2];
                if (dep != null) {
                    dep.addListener((InvalidationListener)this.observer);
                }
                ++n2;
            }
        }
    }

    protected final void syncedUnbind(Observable ... dependencies) {
        if (this.observer != null) {
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable dep = observableArray[n2];
                if (dep != null) {
                    dep.removeListener((InvalidationListener)this.observer);
                }
                ++n2;
            }
            this.observer = null;
        }
    }
}

