/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;

public class RefactoringUtil {
    private RefactoringUtil() {
    }

    public static String buildFullyQualifiedName(IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je != null) {
            IType t;
            block4: {
                try {
                    IJavaProject p = je.getJavaProject();
                    t = p.findType(je.getParent().getElementName(), je.getElementName().replace("." + resource.getFileExtension(), ""));
                    if (t != null) break block4;
                    System.err.println("Unable to construct FQN from '" + je.getParent().getElementName() + "." + je.getElementName().replace("." + resource.getFileExtension(), "") + "'");
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }
            return t.getFullyQualifiedName();
        }
        return RefactoringUtil.getNonJavaElementName(resource, resource.getName());
    }

    private static String getNonJavaElementName(IResource resource, String name) {
        IJavaElement j = JavaCore.create((IResource)resource.getParent());
        if (j instanceof IPackageFragment) {
            IPackageFragment p = (IPackageFragment)j;
            return p.getElementName().replace('.', '/') + "/" + name;
        }
        if (j instanceof IPackageFragmentRoot) {
            return resource.getName();
        }
        return "";
    }

    public static String getNewFullyQualifiedName(IResource resource, String newName) {
        IJavaElement e = JavaCore.create((IResource)resource);
        if (e != null) {
            return e.getParent().getElementName() + "." + newName.replaceAll(".java", "");
        }
        return RefactoringUtil.getNonJavaElementName(resource, newName);
    }

    public static String getNewDestinationFullyQualifiedName(IResource resource, String newDestination) {
        String projectRelativeDestination = "F/" + resource.getProject().getName();
        IJavaElement e = JavaCore.create((IFolder)resource.getProject().getFolder(newDestination.replaceFirst(projectRelativeDestination, "")));
        if (e != null && e instanceof PackageFragment) {
            PackageFragment p = (PackageFragment)e;
            return p.getElementName() + "." + resource.getName().replaceAll(".java", "");
        }
        if (e != null && e instanceof IPackageFragmentRoot) {
            return resource.getName();
        }
        return "bla";
    }
}

