/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.sceneviewer;

import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.sceneviewer.OpenItemEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Viewer3d
extends Pane {
    private SubScene scene;
    private final Rotate cameraXRotation = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
    private final Rotate cameraYRotation = new Rotate(-35.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
    private final Rotate cameraZRotation = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);
    private final Translate cameraPosition = new Translate(0.0, 0.0, -100.0);
    private Camera camera;
    private double dragStartX;
    private double dragStartY;
    private double dragStartRotateX;
    private double dragStartRotateY;
    private RotateTransition rotateTransition;
    Scale contentScale = new Scale(1.0, 1.0, 1.0);
    private Group contentGroup;
    private final @NonNull ObservableList<@NonNull Node> selectedNodes = FXCollections.observableArrayList();
    private final @NonNull ObjectProperty<@Nullable Node> hoverNode = new SimpleObjectProperty((Object)this, "hoverNode");
    private final @NonNull ObjectProperty<@Nullable Node> contentProperty = new SimpleObjectProperty((Object)this, "content");
    private final @NonNull BooleanProperty animated = new SimpleBooleanProperty((Object)this, "rotate");
    private final @NonNull ObjectProperty<@Nullable EventHandler<OpenItemEvent>> onOpenItem = new ObjectPropertyBase<EventHandler<OpenItemEvent>>(){

        protected void invalidated() {
            Viewer3d.this.setEventHandler(OpenItemEvent.OPEN_ITEM, (EventHandler)this.get());
        }

        public Object getBean() {
            return Viewer3d.this;
        }

        public String getName() {
            return "onOpenItem";
        }
    };

    public Viewer3d() {
        this.contentGroup = new Group();
        this.contentGroup.getTransforms().add((Object)this.contentScale);
        Group root = new Group(new Node[]{this.contentGroup});
        this.scene = new SubScene((Parent)root, -1.0, -1.0, true, SceneAntialiasing.BALANCED);
        this.scene.setManaged(false);
        this.camera = this.setupCamera();
        this.scene.setCamera(this.camera);
        root.getChildren().add((Object)this.camera);
        this.scene.widthProperty().addListener(o -> this.updateSize());
        this.scene.heightProperty().addListener(o -> this.updateSize());
        this.getChildren().add((Object)this.scene);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this::cameraRotationHandler);
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::cameraRotationHandler);
        this.addEventHandler(ScrollEvent.SCROLL, this::zoomHandler);
        this.contentProperty().addListener(this::contentHandler);
        this.contentRotateProperty().addListener(this::animationHandler);
    }

    public final @NonNull ObjectProperty<@Nullable EventHandler<OpenItemEvent>> onOpenItemProperty() {
        return this.onOpenItem;
    }

    public final void setOnOpenItem(@Nullable EventHandler<OpenItemEvent> value) {
        this.onOpenItemProperty().set(value);
    }

    public final @Nullable EventHandler<OpenItemEvent> getOpenItem() {
        return (EventHandler)this.onOpenItemProperty().get();
    }

    protected void layoutChildren() {
        this.scene.setWidth(this.getWidth());
        this.scene.setHeight(this.getHeight());
        super.layoutChildren();
    }

    public void zoomIn(double percentage) {
        this.contentScale.setX(this.contentScale.getX() + this.contentScale.getX() * percentage);
        this.contentScale.setY(this.contentScale.getY() + this.contentScale.getY() * percentage);
        this.contentScale.setZ(this.contentScale.getZ() + this.contentScale.getZ() * percentage);
    }

    public void zoomOut(double percentage) {
        this.contentScale.setX(this.contentScale.getX() - this.contentScale.getX() * percentage);
        this.contentScale.setY(this.contentScale.getY() - this.contentScale.getY() * percentage);
        this.contentScale.setZ(this.contentScale.getZ() - this.contentScale.getZ() * percentage);
    }

    public void resetZoom() {
        this.contentScale.setX(1.0);
        this.contentScale.setY(1.0);
        this.contentScale.setZ(1.0);
    }

    public void zoomTo(double target, Duration duration, Consumer<ActionEvent> r) {
        if (duration != null) {
            final double startX = this.contentScale.getX();
            final double delta = target - startX;
            Transition t = new Transition(duration){
                {
                    this.setCycleDuration(duration);
                }

                protected void interpolate(double frac) {
                    Viewer3d.this.contentScale.setX(startX + delta * frac);
                    Viewer3d.this.contentScale.setY(startX + delta * frac);
                    Viewer3d.this.contentScale.setZ(startX + delta * frac);
                }
            };
            if (r != null) {
                t.setOnFinished(e -> r.accept((ActionEvent)e));
            }
            t.playFromStart();
        } else {
            this.contentScale.setX(target);
            this.contentScale.setY(target);
            this.contentScale.setZ(target);
        }
    }

    private void animationHandler(Observable o) {
        if (this.rotateTransition != null) {
            if (this.isContentRotate()) {
                this.rotateTransition.play();
            } else {
                this.rotateTransition.stop();
            }
        }
    }

    public void reevaluate() {
        this.attachListener();
    }

    private void attachListener() {
        Node n = this.getContent();
        if (n != null) {
            for (Node c : n.lookupAll(".component")) {
                if (c.getId() == null) continue;
                for (Node s : c.lookupAll(".shape")) {
                    s.setOnMouseEntered(e -> this.hoverNode.set((Object)c));
                    s.setOnMouseExited(e -> {
                        if (this.hoverNode.get() == c) {
                            this.hoverNode.set(null);
                        }
                    });
                    s.setOnMouseReleased(e -> {
                        if (e.getClickCount() == 2) {
                            this.fireEvent(new OpenItemEvent(c));
                        } else {
                            this.selectedNodes.clear();
                            this.selectedNodes.add((Object)c);
                        }
                    });
                }
            }
        }
    }

    private void contentHandler(Observable o) {
        if (this.getContent() == null) {
            this.contentGroup.getChildren().clear();
        } else {
            this.contentGroup.getChildren().setAll((Object[])new Node[]{this.getContent()});
        }
        this.attachListener();
        this.updateSize();
        this.selectedNodes.clear();
        this.hoverNode.set(null);
        if (this.rotateTransition != null) {
            this.rotateTransition.stop();
        }
        this.rotateTransition = new RotateTransition();
        this.rotateTransition.setAxis(Rotate.Y_AXIS);
        this.rotateTransition.setDelay(Duration.millis((double)4.0));
        this.rotateTransition.setDuration(Duration.millis((double)5000.0));
        this.rotateTransition.setCycleCount(-1);
        this.rotateTransition.setAutoReverse(false);
        this.rotateTransition.setInterpolator(Interpolator.LINEAR);
        this.rotateTransition.setByAngle(360.0);
        this.rotateTransition.setNode(this.getContent());
        if (this.animated.get()) {
            this.rotateTransition.play();
        }
    }

    private void cameraRotationHandler(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.dragStartX = event.getSceneX();
            this.dragStartY = event.getSceneY();
            this.dragStartRotateX = this.cameraXRotation.getAngle();
            this.dragStartRotateY = this.cameraYRotation.getAngle();
        } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
            double xDelta = event.getSceneX() - this.dragStartX;
            double yDelta = event.getSceneY() - this.dragStartY;
            this.cameraXRotation.setAngle(this.dragStartRotateX - yDelta * 0.7);
            this.cameraYRotation.setAngle(this.dragStartRotateY + xDelta * 0.7);
        }
    }

    private void zoomHandler(ScrollEvent event) {
        this.contentScale.setX(this.contentScale.getX() + event.getDeltaY() * 0.01);
        this.contentScale.setY(this.contentScale.getY() + event.getDeltaY() * 0.01);
        this.contentScale.setZ(this.contentScale.getZ() + event.getDeltaY() * 0.01);
    }

    private void updateSize() {
        @Nullable Node content = (Node)this.contentProperty.get();
        if (content != null) {
            double width = content.getLayoutBounds().getWidth();
            double height = content.getLayoutBounds().getHeight();
            double depth = content.getLayoutBounds().getDepth();
            content.setTranslateX(7.8 - width / 2.0);
            content.setTranslateY(height / 2.0);
            content.setTranslateZ(7.8 - depth / 2.0);
            this.cameraPosition.setX(this.getWidth() / -2.0);
            this.cameraPosition.setY(this.getHeight() / -2.0);
        }
    }

    private Camera setupCamera() {
        PerspectiveCamera camera = new PerspectiveCamera();
        camera.getTransforms().addAll((Object[])new Transform[]{this.cameraXRotation, this.cameraYRotation, this.cameraZRotation, this.cameraPosition});
        return camera;
    }

    public void setCameraXRotation(double xRotation) {
        this.cameraXRotation.setAngle(xRotation);
    }

    public double getCameraXRotation() {
        return this.cameraXRotation.getAngle();
    }

    public void setCameraYRotation(double yRotation) {
        this.cameraYRotation.setAngle(yRotation);
    }

    public double getCameraYRotation() {
        return this.cameraYRotation.getAngle();
    }

    public void setCameraZRotation(double zRotation) {
        this.cameraZRotation.setAngle(zRotation);
    }

    public double getCameraZRotation() {
        return this.cameraZRotation.getAngle();
    }

    public void rotateCameraTo(double x, double y, double z) {
        this.setCameraXRotation(x);
        this.setCameraYRotation(y);
        this.setCameraPositionZ(z);
    }

    public void rotateCameraBy(double deltaX, double deltaY, double deltaZ) {
        this.setCameraXRotation(this.getCameraXRotation() + deltaX);
        this.setCameraYRotation(this.getCameraYRotation() + deltaY);
        this.setCameraPositionZ(this.getCameraZRotation() + deltaZ);
    }

    public void setContentScaleX(double scaleX) {
        this.contentScale.setX(scaleX);
    }

    public double getContentScaleX() {
        return this.contentScale.getX();
    }

    public void setContentScaleY(double scaleY) {
        this.contentScale.setY(scaleY);
    }

    public double getContentScaleY() {
        return this.contentScale.getY();
    }

    public void setContentScaleZ(double scaleZ) {
        this.contentScale.setZ(scaleZ);
    }

    public double getContentScaleZ() {
        return this.contentScale.getZ();
    }

    public void scaleTo(double scale) {
        this.scaleTo(scale, scale, scale);
    }

    public void scaleTo(double scaleX, double scaleY, double scaleZ) {
        this.setContentScaleX(scaleX);
        this.setContentScaleY(scaleY);
        this.setContentScaleZ(scaleZ);
    }

    public void scaleBy(double delta) {
        this.setContentScaleX(this.getContentScaleX() + delta);
        this.setContentScaleY(this.getContentScaleY() + delta);
        this.setContentScaleZ(this.getContentScaleZ() + delta);
    }

    public void scaleBy(double deltaX, double deltaY, double deltaZ) {
        this.setContentScaleX(this.getContentScaleX() + deltaX);
        this.setContentScaleY(this.getContentScaleY() + deltaY);
        this.setContentScaleZ(this.getContentScaleZ() + deltaZ);
    }

    public void setCameraPositionX(double positionX) {
        this.cameraPosition.setX(positionX);
    }

    public double getCameraPositionX() {
        return this.cameraPosition.getX();
    }

    public void setCameraPositionY(double positionY) {
        this.cameraPosition.setY(positionY);
    }

    public double getCameraPositionY() {
        return this.cameraPosition.getY();
    }

    public void setCameraPositionZ(double positionZ) {
        this.cameraPosition.setZ(positionZ);
    }

    public double getCameraPositionZ() {
        return this.cameraPosition.getZ();
    }

    public void moveCameraTo(double x, double y, double z) {
        this.setCameraPositionX(x);
        this.setCameraPositionY(y);
        this.setCameraPositionZ(z);
    }

    public void moveCameraBy(double deltaX, double deltaY, double deltaZ) {
        this.moveCameraTo(this.getCameraPositionX() + deltaX, this.getCameraPositionY() + deltaY, this.getCameraPositionZ() + deltaZ);
    }

    public void setContent(@Nullable Node node) {
        this.contentProperty.set((Object)node);
    }

    public @Nullable Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public @NonNull ObjectProperty<@Nullable Node> contentProperty() {
        return this.contentProperty;
    }

    public boolean isContentRotate() {
        return this.contentRotateProperty().get();
    }

    public void setContentRotate(boolean rotate) {
        this.contentRotateProperty().set(rotate);
    }

    public @NonNull BooleanProperty contentRotateProperty() {
        return this.animated;
    }

    public @NonNull ObservableList<@NonNull Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Node> hoverNodeProperty() {
        return this.hoverNode;
    }

    public @Nullable Node getHoverNode() {
        return (Node)this.hoverNode.get();
    }
}

