/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class ScrollbarPane<N extends Node>
extends Region {
    public final ScrollBar horizontal = new ScrollBar();
    public final ScrollBar vertical;
    private Rectangle clip;
    private N center;

    public ScrollbarPane() {
        this.horizontal.setOrientation(Orientation.HORIZONTAL);
        this.vertical = new ScrollBar();
        this.vertical.setOrientation(Orientation.VERTICAL);
        this.clip = new Rectangle();
        this.getChildren().setAll((Object[])new Node[]{this.horizontal, this.vertical});
    }

    public void setCenter(N center) {
        if (this.center != null) {
            this.center.setClip(null);
            this.getChildren().remove(this.center);
        }
        this.center = center;
        if (this.center != null) {
            this.center.setClip((Node)this.clip);
            this.getChildren().add(0, this.center);
        }
    }

    protected void layoutChildren() {
        boolean space = false;
        int w = 16;
        this.horizontal.resizeRelocate(0.0, this.getHeight() - (double)w, this.getWidth() - (double)w, (double)w);
        this.vertical.resizeRelocate(this.getWidth() - (double)w, 0.0, (double)w, this.getHeight() - (double)w);
        if (this.center != null) {
            this.clip.setX(0.0);
            this.clip.setY(0.0);
            this.clip.setWidth(this.getWidth() - (double)w - (double)space);
            this.clip.setHeight(this.getHeight() - (double)w - (double)space);
            this.center.resizeRelocate(0.0, 0.0, this.getWidth() - (double)w - (double)space, this.getHeight() - (double)w - (double)space);
        }
    }
}

