/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import java.util.List;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.ui.controls.tree.TreeItemPredicate;

public class FilterableTreeItem<T>
extends CheckBoxTreeItem<T> {
    private final ObservableList<TreeItem<T>> sourceList = FXCollections.observableArrayList();
    private final FilteredList<TreeItem<T>> filteredList = new FilteredList(this.sourceList);
    private final ObjectProperty<TreeItemPredicate<T>> predicate = new SimpleObjectProperty();

    public FilterableTreeItem(T value) {
        super(value);
        this.filteredList.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Predicate<TreeItem> p = child -> {
                if (child instanceof FilterableTreeItem) {
                    FilterableTreeItem filterableChild = (FilterableTreeItem)((Object)((Object)child));
                    filterableChild.setPredicate((TreeItemPredicate)this.predicate.get());
                }
                if (this.predicate.get() == null) {
                    return true;
                }
                if (child.getChildren().size() > 0) {
                    return true;
                }
                return ((TreeItemPredicate)this.predicate.get()).test(this, child.getValue());
            };
            return p;
        }, (Observable[])new Observable[]{this.predicate}));
        Bindings.bindContent((List)this.getChildren(), this.getBackingList());
    }

    protected ObservableList<TreeItem<T>> getBackingList() {
        return this.filteredList;
    }

    public ObservableList<TreeItem<T>> getInternalChildren() {
        return this.sourceList;
    }

    public final ObjectProperty<TreeItemPredicate<T>> predicateProperty() {
        return this.predicate;
    }

    public final TreeItemPredicate<T> getPredicate() {
        return (TreeItemPredicate)this.predicate.get();
    }

    public final void setPredicate(TreeItemPredicate<T> predicate) {
        this.predicate.set(predicate);
    }
}

