/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fx.ide.fxml.editors.FXMLTextHover;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FXMLHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion hoverRegion, boolean canShowMultipleHyperlinks) {
        ITextRegion region;
        if (hoverRegion == null || textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        int documentOffset = hoverRegion.getOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentOffset);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentOffset);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentOffset)) != null) {
            String regionType = region.getType();
            Object link = null;
            if (regionType == "XML_TAG_NAME") {
                IDOMNode dom = (IDOMNode)treeNode;
                if (!(dom instanceof ProcessingInstruction)) {
                    link = new FXMLJavaElementHyperLink(null, (IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), dom, regionType, documentOffset);
                }
            } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                IDOMNode dom = (IDOMNode)treeNode;
                if (dom instanceof ProcessingInstruction) {
                    String fqn = dom.getNodeValue();
                    if (fqn.endsWith("?")) {
                        fqn = fqn.substring(0, fqn.length() - 1);
                    }
                    link = new FXMLJavaElementHyperLink((IJavaElement)Util.findType(fqn, dom.getOwnerDocument()), (IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), (IDOMNode)treeNode, regionType, documentOffset);
                } else {
                    link = new FXMLJavaElementHyperLink(null, (IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), (IDOMNode)treeNode, regionType, documentOffset);
                }
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                IJavaElement element = FXMLTextHover.computeTagAttValueHelp((IDOMNode)treeNode, documentOffset);
                if (element != null) {
                    link = new FXMLJavaElementHyperLink(element, (IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), (IDOMNode)treeNode, regionType, documentOffset);
                }
            } else if (regionType == "XML_PI_CONTENT") {
                IDOMNode dom = (IDOMNode)treeNode;
                String value = dom.getNodeValue();
                if (value.endsWith("?")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.endsWith(".css") || value.endsWith(".properties")) {
                    link = new ResourceHyperLink((IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), (IDOMNode)treeNode, value);
                } else if (!value.endsWith("*")) {
                    link = new FXMLJavaElementHyperLink((IJavaElement)Util.findType(value, dom.getOwnerDocument()), (IRegion)new Region(flatNode.getStartOffset(region), region.getTextLength()), (IDOMNode)treeNode, regionType, documentOffset);
                }
            }
            if (link != null) {
                return new IHyperlink[]{link};
            }
        }
        return null;
    }

    static class FXMLJavaElementHyperLink
    implements IHyperlink {
        private final IRegion region;
        private final IDOMNode xmlnode;
        private final String regionType;
        private final int documentOffset;
        private final IJavaElement element;

        public FXMLJavaElementHyperLink(IJavaElement element, IRegion region, IDOMNode xmlnode, String regionType, int documentOffset) {
            this.element = element;
            this.region = region;
            this.xmlnode = xmlnode;
            this.regionType = regionType;
            this.documentOffset = documentOffset;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            IJavaElement element = this.element;
            if (element == null) {
                if (this.regionType == "XML_TAG_NAME") {
                    element = FXMLTextHover.computeTagNameHelp(this.xmlnode);
                } else if (this.regionType == "XML_TAG_ATTRIBUTE_NAME") {
                    element = FXMLTextHover.computeTagAttNameHelp(this.xmlnode, this.documentOffset);
                } else if (this.regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                    element = FXMLTextHover.computeTagAttValueHelp(this.xmlnode, this.documentOffset);
                }
            }
            if (element != null) {
                try {
                    JavaUI.openInEditor((IJavaElement)element);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class ResourceHyperLink
    implements IHyperlink {
        private final IRegion region;
        private final IDOMNode xmlnode;
        private final String resourceValue;

        public ResourceHyperLink(IRegion region, IDOMNode xmlnode, String resourceValue) {
            this.region = region;
            this.xmlnode = xmlnode;
            this.resourceValue = resourceValue;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            String baseLocation = this.xmlnode.getModel().getBaseLocation();
            IContainer c = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(baseLocation)).getParent();
            IFile f = c.getFile((IPath)new Path(this.resourceValue));
            if (this.resourceValue.endsWith(".css")) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(f), "org.eclipse.fx.ide.css.CssDsl");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

