/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.formatting;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.css.services.CssDslGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfigBasedStream;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.util.Pair;

public class CssDslFormatter
extends AbstractDeclarativeFormatter {
    @Inject
    private IHiddenTokenHelper hiddenTokenHelper;

    protected void configureFormatting(FormattingConfig c) {
        CssDslGrammarAccess f = (CssDslGrammarAccess)this.getGrammarAccess();
        c.setSpace(" ").after((EObject)f.getCss_propertyRule());
        c.setSpace(" ").around((EObject)f.getSymbolTokRule());
        for (Keyword semicolon : f.findKeywords(new String[]{";"})) {
            c.setNoSpace().before((EObject)semicolon);
            c.setLinewrap().after((EObject)semicolon);
        }
        for (Keyword colon : f.findKeywords(new String[]{":"})) {
            c.setNoSpace().before((EObject)colon);
            c.setSpace(" ").after((EObject)colon);
        }
        for (Pair braces : f.findKeywordPairs("{", "}")) {
            c.setIndentationIncrement().after((EObject)braces.getFirst());
            c.setIndentationDecrement().before((EObject)braces.getSecond());
            c.setLinewrap().after((EObject)braces.getFirst());
            c.setLinewrap().before((EObject)braces.getSecond());
            c.setLinewrap(2).after((EObject)braces.getSecond());
        }
    }

    public ITokenStream createFormatterStream(String indent, ITokenStream out, boolean preserveWhitespaces) {
        return new SemanticWSEaterFormattingConfigBasedStream(out, indent, this.getConfig(), (IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern>)this.createMatcher(), this.hiddenTokenHelper, preserveWhitespaces);
    }

    public ITokenStream createFormatterStream(EObject context, String indent, ITokenStream out, boolean preserveWhitespaces) {
        super.createFormatterStream(context, indent, out, preserveWhitespaces);
        return new SemanticWSEaterFormattingConfigBasedStream(out, indent, this.getConfig(), (IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern>)this.createMatcher(), this.hiddenTokenHelper, preserveWhitespaces);
    }

    public static class SemanticWSEaterFormattingConfigBasedStream
    extends FormattingConfigBasedStream {
        public SemanticWSEaterFormattingConfigBasedStream(ITokenStream out, String initialIndentation, FormattingConfig cfg, IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> matcher, IHiddenTokenHelper hiddenTokenHelper, boolean preserveSpaces) {
            super(out, initialIndentation, cfg, matcher, hiddenTokenHelper, preserveSpaces);
        }

        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            AbstractRule rule;
            System.err.println("writeSemantic " + String.valueOf(grammarElement) + " v:'" + value + "'");
            if (grammarElement instanceof RuleCall && "WS".equals((rule = ((RuleCall)grammarElement).getRule()).getName())) {
                this.writeHidden(grammarElement, value);
                return;
            }
            super.writeSemantic(grammarElement, value);
        }

        public void writeHidden(EObject grammarElement, String value) throws IOException {
            AbstractRule rule;
            System.err.println("writeHidden " + String.valueOf(grammarElement) + " v:'" + value + "'");
            if (grammarElement instanceof RuleCall && (rule = ((RuleCall)grammarElement).getRule()).getName().equals("WS")) {
                System.err.println("eating " + String.valueOf(grammarElement) + " for hidden ws");
                this.preservedWS = this.preservedWS == null ? value : String.valueOf(this.preservedWS) + value;
                return;
            }
            super.writeHidden(grammarElement, value);
        }
    }
}

