/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.converter;

import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.fxgraph.converter.CastHelper;
import org.eclipse.fx.ide.fxgraph.converter.ValuePropertyFormatter;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FactoryValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FXGraphConverter {
    public CharSequence generate(Model model) {
        int _length;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        PackageDeclaration _package = null;
        if (model != null) {
            _package = model.getPackage();
        }
        String _name = null;
        if (_package != null) {
            _name = _package.getName();
        }
        boolean bl = _greaterThan = (_length = _name.length()) > 0;
        if (_greaterThan) {
            _builder.append("package ");
            String _name_1 = model.getPackage().getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _generateImports = this.generateImports(model.getImports());
        _builder.append((Object)_generateImports);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateComponentDefinition = this.generateComponentDefinition(model.getComponentDef());
        _builder.append((Object)_generateComponentDefinition);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateComponentDefinition(ComponentDefinition cd) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isDynamicRoot = cd.isDynamicRoot();
        if (_isDynamicRoot) {
            _builder.append("dynamic ");
        }
        _builder.append("component ");
        String _name = cd.getName();
        _builder.append(_name);
        CharSequence _generateController = this.generateController(cd.getController());
        _builder.append((Object)_generateController);
        CharSequence _generateStyle = this.generateStyle(cd.getPreviewCssFiles());
        _builder.append((Object)_generateStyle);
        CharSequence _generateResourceBundle = this.generateResourceBundle(cd.getPreviewResourceBundle());
        _builder.append((Object)_generateResourceBundle);
        CharSequence _generateExtraClassPath = this.generateExtraClassPath(cd.getPreviewClasspathEntries());
        _builder.append((Object)_generateExtraClassPath);
        CharSequence _generateSceneSetup = this.generateSceneSetup(cd.getSceneDefinition());
        _builder.append((Object)_generateSceneSetup);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList<Script> _scripts = cd.getScripts();
        for (Script s : _scripts) {
            _builder.append("\t");
            CharSequence _generateScript = this.generateScript(s);
            _builder.append((Object)_generateScript, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<Define> _defines = cd.getDefines();
        for (Define d : _defines) {
            _builder.append("\t");
            if (comma.booleanValue()) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateDefine = this.generateDefine(d);
            _builder.append((Object)_generateDefine, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Boolean nix = comma = Boolean.valueOf(true);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _generateElement = this.generateElement(cd.getRootNode());
        _builder.append((Object)_generateElement, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateDefine(Define define) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("define ");
        CharSequence _generateElement = this.generateElement(define.getElement());
        _builder.append((Object)_generateElement);
        return _builder;
    }

    public CharSequence generateController(JvmTypeReference controller) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equals(controller, null);
        if (_notEquals) {
            _builder.append(" controlledby ");
            String _simpleName = controller.getType().getSimpleName();
            _builder.append(_simpleName);
        }
        return _builder;
    }

    public CharSequence generateStyle(EList<String> previewCssFiles) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = previewCssFiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(" styledwith [\"");
            for (String css : previewCssFiles) {
                _builder.append(css);
            }
            _builder.append("\"]");
        }
        return _builder;
    }

    public CharSequence generateResourceBundle(String previewResourceBundle) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equals(previewResourceBundle, null);
        if (_notEquals) {
            _builder.append(" resourcefile \"");
            _builder.append(previewResourceBundle);
            _builder.append("\"");
        }
        return _builder;
    }

    public CharSequence generateExtraClassPath(EList<String> previewClasspathEntries) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = previewClasspathEntries.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(" extraClasspath [\"");
            for (String cp : previewClasspathEntries) {
                _builder.append(cp);
            }
            _builder.append("\"]");
        }
        return _builder;
    }

    public CharSequence generateSceneSetup(ComponentDefinition sceneDefinition) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equals(sceneDefinition, null);
        if (_notEquals) {
            _builder.append(" sceneSetup \"");
            CharSequence _generateComponentDefinition = this.generateComponentDefinition(sceneDefinition);
            _builder.append((Object)_generateComponentDefinition);
            _builder.append("\"");
        }
        return _builder;
    }

    public CharSequence generateImports(EList<Import> imports) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = imports.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.newLine();
        }
        for (Import imp : imports) {
            _builder.append("import ");
            String _importedNamespace = imp.getImportedNamespace();
            _builder.append(_importedNamespace);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateScript(Script s) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("script ");
        String _language = s.getLanguage();
        _builder.append(_language);
        _builder.append(" #{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _source = s.getSource();
        boolean bl = _notEquals = !Objects.equals(_source, null);
        if (_notEquals) {
            String _source_1 = s.getSource();
            _builder.append(_source_1, "\t");
        } else {
            String _sourcecode = s.getSourcecode();
            _builder.append(_sourcecode, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}#\t");
        return _builder;
    }

    public CharSequence generateElement(Element element) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _factory = element.getFactory();
        boolean bl = _notEquals = !Objects.equals(_factory, null);
        if (_notEquals) {
            String _simpleName = element.getType().getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" createdby ");
            String _factory_1 = element.getFactory();
            _builder.append(_factory_1);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            Boolean comma = false;
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values = element.getValues();
            for (FactoryValueElement e : _values) {
                if (comma.booleanValue()) {
                    _builder.append(",");
                }
                if (e instanceof Element) {
                    CharSequence _generateElement = this.generateElement((Element)e);
                    _builder.append((Object)_generateElement);
                } else {
                    boolean cfr_ignored_0 = e instanceof SimpleValueProperty;
                    String _formattedValue = new ValuePropertyFormatter(e).getFormattedValue();
                    _builder.append(_formattedValue);
                }
                _builder.newLineIfNotEmpty();
                Boolean nix = comma = Boolean.valueOf(true);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
        } else {
            boolean _elementHasSubEntries;
            String _name;
            boolean _notEquals_2;
            boolean _notEquals_1;
            _builder.newLineIfNotEmpty();
            String _simpleName_1 = element.getType().getSimpleName();
            _builder.append(_simpleName_1);
            SimpleValueProperty _value = element.getValue();
            boolean bl2 = _notEquals_1 = !Objects.equals(_value, null);
            if (_notEquals_1) {
                _builder.append(" ( ");
                String _stringValue = element.getValue().getStringValue();
                _builder.append(_stringValue);
                _builder.append(" )");
            }
            boolean bl3 = _notEquals_2 = !Objects.equals(_name = element.getName(), null);
            if (_notEquals_2) {
                _builder.append(" id ");
                String _name_1 = element.getName();
                _builder.append(_name_1);
            }
            if (_elementHasSubEntries = this.elementHasSubEntries(element)) {
                boolean _greaterThan;
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                Boolean comma_1 = false;
                _builder.newLineIfNotEmpty();
                EList<Property> _properties = element.getProperties();
                for (Property p : _properties) {
                    ValueProperty _value_1;
                    if (comma_1.booleanValue()) {
                        _builder.append(",");
                    }
                    if ((_value_1 = p.getValue()) instanceof Element) {
                        CharSequence _generatePropertyElement = this.generatePropertyElement(p);
                        _builder.append((Object)_generatePropertyElement);
                    } else {
                        ValueProperty _value_2 = p.getValue();
                        if (_value_2 instanceof ListValueProperty) {
                            CharSequence _generateListValueProperty = this.generateListValueProperty(p);
                            _builder.append((Object)_generateListValueProperty);
                        } else {
                            ValueProperty _value_3 = p.getValue();
                            if (_value_3 instanceof MapValueProperty) {
                                CharSequence _generateMapValueProperty = this.generateMapValueProperty(p);
                                _builder.append((Object)_generateMapValueProperty);
                            } else {
                                String _formattedValue_1 = new ValuePropertyFormatter(p).getFormattedValue();
                                _builder.append(_formattedValue_1);
                            }
                        }
                    }
                    _builder.newLineIfNotEmpty();
                    Boolean nix_1 = comma_1 = Boolean.valueOf(true);
                    _builder.newLineIfNotEmpty();
                }
                EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
                for (StaticValueProperty p_1 : _staticProperties) {
                    if (comma_1.booleanValue()) {
                        _builder.append(",");
                    }
                    String _formattedValue_2 = new ValuePropertyFormatter(p_1).getFormattedValue();
                    _builder.append(_formattedValue_2);
                    _builder.newLineIfNotEmpty();
                    Boolean nix_2 = comma_1 = Boolean.valueOf(true);
                    _builder.newLineIfNotEmpty();
                }
                EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
                for (StaticCallValueProperty p_2 : _staticCallProperties) {
                    if (comma_1.booleanValue()) {
                        _builder.append(",");
                    }
                    String _formattedValue_3 = new ValuePropertyFormatter(p_2).getFormattedValue();
                    _builder.append(_formattedValue_3);
                    _builder.newLineIfNotEmpty();
                    Boolean nix_3 = comma_1 = Boolean.valueOf(true);
                    _builder.newLineIfNotEmpty();
                }
                int _size = element.getDefaultChildren().size();
                boolean bl4 = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _builder.append("\t");
                    if (comma_1.booleanValue()) {
                        _builder.append(",");
                    }
                    _builder.append("children : [");
                    _builder.newLineIfNotEmpty();
                    Boolean internalComma = false;
                    _builder.newLineIfNotEmpty();
                    EList<Element> _defaultChildren = element.getDefaultChildren();
                    for (Element e_1 : _defaultChildren) {
                        if (internalComma.booleanValue()) {
                            _builder.append(",");
                        }
                        CharSequence _generateElement_1 = this.generateElement(e_1);
                        _builder.append((Object)_generateElement_1);
                        _builder.newLineIfNotEmpty();
                        Boolean nix_4 = internalComma = Boolean.valueOf(true);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("]");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("}");
            }
        }
        return _builder;
    }

    public boolean elementHasSubEntries(Element element) {
        return element.getProperties().size() > 0 || element.getStaticProperties().size() > 0 || element.getStaticCallProperties().size() > 0 || element.getDefaultChildren().size() > 0;
    }

    public CharSequence generateMapValueProperty(Property p) {
        StringConcatenation _builder = new StringConcatenation();
        MapValueProperty list = new CastHelper().castToMapValueProperty(p.getValue());
        _builder.newLineIfNotEmpty();
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(" : [");
        _builder.newLineIfNotEmpty();
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<Property> _properties = list.getProperties();
        for (Property inner : _properties) {
            _builder.append("\t");
            if (comma.booleanValue()) {
                _builder.append(",");
            }
            if ("Integer".equals(inner.getName()) || "Double".equals(inner.getName())) {
                String _formattedValue = new ValuePropertyFormatter(inner).getFormattedValue();
                _builder.append(_formattedValue, "\t");
            } else {
                String _name_1 = inner.getName();
                _builder.append(_name_1, "\t");
                _builder.append("(");
                ValueProperty _value = inner.getValue();
                String _formattedValue_1 = new ValuePropertyFormatter(_value).getFormattedValue();
                _builder.append(_formattedValue_1, "\t");
                _builder.append(")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Boolean nix = comma = Boolean.valueOf(true);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("]");
        return _builder;
    }

    public CharSequence generateListValueProperty(Property p) {
        StringConcatenation _builder = new StringConcatenation();
        ListValueProperty list = new CastHelper().castToListValueProperty(p.getValue());
        _builder.newLineIfNotEmpty();
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(" : [");
        _builder.newLineIfNotEmpty();
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<ListValueElement> _value = list.getValue();
        for (ListValueElement e : _value) {
            if (comma.booleanValue()) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            if (e instanceof Element) {
                CharSequence _generateElement = this.generateElement((Element)e);
                _builder.append((Object)_generateElement);
            } else {
                String _formattedValue = new ValuePropertyFormatter(e).getFormattedValue();
                _builder.append(_formattedValue);
            }
            _builder.newLineIfNotEmpty();
            Boolean nix = comma = Boolean.valueOf(true);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("]");
        return _builder;
    }

    public CharSequence generatePropertyElement(Property p) {
        char _charAt_1;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        char _charAt = p.getName().charAt(0);
        boolean bl = _equals = _charAt == (_charAt_1 = StringExtensions.toFirstLower((String)p.getName()).charAt(0));
        if (_equals) {
            String _name = p.getName();
            _builder.append(_name);
            _builder.append(" : ");
        }
        CharSequence _generateElement = this.generateElement(new CastHelper().castToElement(p.getValue()));
        _builder.append((Object)_generateElement);
        return _builder;
    }

    public CharSequence generateFactory(Element element) {
        StringConcatenation _builder = new StringConcatenation();
        if (!Objects.equals(element.getFactory(), null) && !element.getValues().isEmpty()) {
            _builder.append("createdby ");
            String _factory = element.getFactory();
            _builder.append(_factory);
            _builder.append(" { ");
            _builder.newLineIfNotEmpty();
            Boolean comma = false;
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values = element.getValues();
            for (FactoryValueElement e : _values) {
                if (comma.booleanValue()) {
                    _builder.append(",");
                }
                _builder.newLineIfNotEmpty();
                if (e instanceof Element) {
                    CharSequence _generateElement = this.generateElement((Element)e);
                    _builder.append((Object)_generateElement);
                    _builder.newLineIfNotEmpty();
                } else {
                    if (e instanceof SimpleValueProperty) {
                        String _formattedValue = new ValuePropertyFormatter(e).getFormattedValue();
                        _builder.append(_formattedValue);
                    }
                    _builder.newLineIfNotEmpty();
                }
                Boolean nix = comma = Boolean.valueOf(true);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
        }
        return _builder;
    }
}

