/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.resXcomp1;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.xa.ee.resXcomp1.TxBean;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="xa"), @Tag(value="platform")})
public class Client
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private Properties testProps = null;
    protected String txRef = "java:comp/env/ejb/MyEjbReference";
    private TxBean beanRef = null;
    private UserTransaction ut = null;
    private String tName1 = null;
    private Integer tSize = null;
    private Integer fromKey1 = null;
    private Integer fromKey2 = null;
    private Integer toKey2 = null;

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.testProps = p;
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Setup tests");
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)("Lookup TxBean: " + this.txRef));
            this.beanRef = (TxBean)this.nctx.lookup(this.txRef, TxBean.class);
            TestUtil.logMsg((String)"Lookup java:comp/UserTransaction");
            this.ut = (UserTransaction)this.nctx.lookup("java:comp/UserTransaction");
            TestUtil.logMsg((String)"Lookup environment variables");
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
            this.tSize = (Integer)this.nctx.lookup("java:comp/env/size");
            TestUtil.logTrace((String)("tSize: " + this.tSize));
            this.fromKey1 = (Integer)this.nctx.lookup("java:comp/env/fromKey1");
            TestUtil.logTrace((String)("fromKey1: " + this.fromKey1));
            this.fromKey2 = (Integer)this.nctx.lookup("java:comp/env/fromKey2");
            TestUtil.logTrace((String)("fromKey2: " + this.fromKey2));
            this.toKey2 = (Integer)this.nctx.lookup("java:comp/env/toKey2");
            TestUtil.logTrace((String)("toKey2: " + this.toKey2));
            TestUtil.logMsg((String)("Initialize " + this.txRef));
            this.beanRef.initialize();
            TestUtil.logMsg((String)"Initialize logging data from server");
            this.beanRef.initLogging(p);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in setup: ", (Throwable)e);
            throw new Exception("setup failed", e);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup ok");
    }

    public void test1() throws Exception {
        String testname = "test1";
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
            TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            this.beanRef.createData(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete(tName1, tRng, tRng);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            dbResults = this.beanRef.getResults(tName1);
            TestUtil.logMsg((String)"Verifying the test results");
            if (!dbResults.contains(new Integer(tRng))) {
                b1 = true;
            }
            for (int i = 1; i <= tSize; ++i) {
                if (i == tRng) continue;
                if (dbResults.contains(new Integer(i))) {
                    b2 = true;
                    continue;
                }
                b2 = false;
                break;
            }
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName1);
                this.beanRef.destroyData(tName1);
                this.beanRef.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test2() throws Exception {
        String testname = "test2";
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tSizeOrig = this.tSize;
        int tRngFrom = this.fromKey2;
        int tRngTo = this.toKey2;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
            TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            this.beanRef.createData(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete(tName1, tRngFrom, tRngTo);
            this.beanRef.dbUnConnect(tName1);
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            dbResults = this.beanRef.getResults(tName1);
            TestUtil.logMsg((String)"Verifying the test results");
            for (int i = 1; i <= tSizeOrig; ++i) {
                if (!dbResults.contains(new Integer(i))) {
                    b1 = false;
                    break;
                }
                b1 = true;
            }
            for (int j = tSize; j > tSizeOrig; --j) {
                if (dbResults.contains(new Integer(j))) {
                    b2 = false;
                    break;
                }
                b2 = true;
            }
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            if (b1) {
                TestUtil.logTrace((String)"b1 true");
            }
            if (b2) {
                TestUtil.logTrace((String)"b2 true");
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName1);
                this.beanRef.destroyData(tName1);
                this.beanRef.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test3() throws Exception {
        String testname = "test3";
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
            TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
            TestUtil.logMsg((String)"Creating the data");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            this.beanRef.createData("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert("EIS", tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert("EIS", tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete("EIS", tRng, tRng);
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            dbResults = this.beanRef.getResults("EIS");
            TestUtil.logMsg((String)"Verifying the test results");
            if (!dbResults.contains(new Integer(tRng).toString())) {
                b1 = true;
            }
            for (int i = 1; i <= tSize; ++i) {
                if (i == tRng) continue;
                if (dbResults.contains(new Integer(i).toString())) {
                    b2 = true;
                    continue;
                }
                b2 = false;
                break;
            }
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect("EIS");
                this.beanRef.destroyData("EIS");
                this.beanRef.dbUnConnect("EIS");
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test4() throws Exception {
        String testname = "test4";
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tSizeOrig = this.tSize;
        int tRngFrom = this.fromKey2;
        int tRngTo = this.toKey2;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
            TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            this.beanRef.createData("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert("EIS", tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert("EIS", tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete("EIS", tRngFrom, tRngTo);
            this.beanRef.dbUnConnect("EIS");
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            dbResults = this.beanRef.getResults("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Verifying the test results");
            for (int i = 1; i <= tSizeOrig; ++i) {
                if (!dbResults.contains(new Integer(i).toString())) {
                    b1 = false;
                    break;
                }
                b1 = true;
            }
            for (int j = tSize; j > tSizeOrig; --j) {
                if (dbResults.contains(new Integer(j).toString())) {
                    b2 = false;
                    break;
                }
                b2 = true;
            }
            if (b1) {
                TestUtil.logTrace((String)"b1 true");
            }
            if (b2) {
                TestUtil.logTrace((String)"b2 true");
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect("EIS");
                this.beanRef.destroyData("EIS");
                this.beanRef.dbUnConnect("EIS");
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }
}

