/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.workcontext;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class WorkContextClient
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_mdcomplete = null;
    private String whitebox_anno = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private TSDataSource ds3 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        WorkContextClient theTests = new WorkContextClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_mdcomplete = p.getProperty("whitebox-mdcomplete");
        this.whitebox_anno = p.getProperty("whitebox-anno_no_md");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_mdcomplete);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new Exception("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_mdcomplete);
            this.ds3 = (TSDataSource)this.nctx.lookup(this.whitebox_anno);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testIsContextSupported() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "TransactionContext supported by Server.";
        String toCheck2 = "SecurityContext supported by Server.";
        String toCheck3 = "HintsContext supported by Server";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (b1 && b2 && b3) {
            TestUtil.logMsg((String)"Methods called correctly");
        } else {
            if (!b1) {
                throw new Exception("TransactionContext not supported by server.");
            }
            if (!b2) {
                throw new Exception("SecurityContext not supported by server.");
            }
            if (!b3) {
                throw new Exception("HintsContext not supported by server.");
            }
        }
    }

    public void testSecurityContextExecSubject() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "setupSecurityContext() called with valid executionSubject";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
            break;
        }
        if (!b1) {
            throw new Exception("testSecurityContextExecSubject() failed.");
        }
        TestUtil.logMsg((String)"testSecurityContextExecSubject() passed");
    }

    public void testSecurityContextServiceSubject() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "setupSecurityContext() called with valid serviceSubject";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
            break;
        }
        if (!b1) {
            throw new Exception("testSecurityContextServiceSubject() failed.");
        }
        TestUtil.logMsg((String)"testSecurityContextServiceSubject() passed");
    }

    public void testSecurityContextCBH() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "setupSecurityContext() called with non-null callbackHandler";
        String toCheck2 = "setupSecurityContext callbackhandler supports required callback types.";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new Exception("testSecurityContextCBH() failed.");
        }
        TestUtil.logMsg((String)"testSecurityContextCBH() passed");
    }

    public void testWorkContextErrorCode() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "MDCompleteWorkManager threw WorkContextErrorCodes.UNSUPPORTED_CONTEXT_TYPE";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("testWorkContextErrorCode() failed.");
        }
        TestUtil.logMsg((String)"testWorkContextErrorCode() passed");
    }

    public void testWorkContextErrorCode2() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "MDCompleteWorkManager threw WorkContextErrorCodes.DUPLICATE_CONTEXTS";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("testWorkContextErrorCode2() failed.");
        }
        TestUtil.logMsg((String)"testWorkContextErrorCode2() passed");
    }

    public void testNestedWorkContexts() throws Exception {
        String str;
        int i;
        Vector log = null;
        Vector log3 = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TSConnection con3 = null;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            con3 = this.ds3.getConnection();
            log3 = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got connections.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (con3 != null) {
                    con3.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String toCheck1 = "Nested Work and Nested Security Context worked.";
        String toCheck2 = "anno based NestedWorkXid1 parent context submitted";
        String toCheck3 = "anno based NestedWorkXid1 child context submitted";
        TestUtil.logTrace((String)log.toString());
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        TestUtil.logTrace((String)log3.toString());
        for (i = 0; i < log3.size(); ++i) {
            str = (String)log3.elementAt(i);
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (!(b1 && b2 && b3)) {
            if (!b1) {
                TestUtil.logMsg((String)("testNestedWorkContexts() - could not find string: " + toCheck1));
            }
            if (!b2) {
                TestUtil.logMsg((String)("testNestedWorkContexts() - could not find string: " + toCheck2));
            }
            if (!b3) {
                TestUtil.logMsg((String)("testNestedWorkContexts() - could not find string: " + toCheck3));
            }
            throw new Exception("testNestedWorkContexts() failed.");
        }
        TestUtil.logMsg((String)"testNestedWorkContexts() passed");
    }

    public void testNestedWorkContexts2() throws Exception {
        Vector log = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck2 = "TSNestedSecurityContext expected PVC failure and got it.";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)("testNestedWorkContexts2() failed - could not find string: " + toCheck2));
            throw new Exception("testNestedWorkContexts2() failed.");
        }
        TestUtil.logMsg((String)"testNestedWorkContexts2() passed");
    }

    public void testNestedWorkContexts3() throws Exception {
        Vector log = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck2 = "TSNestedSecurityContext expected PVC failure and got it.";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)("testNestedWorkContexts3() failed - could not find string: " + toCheck2));
            throw new Exception("testNestedWorkContexts3() failed.");
        }
        TestUtil.logMsg((String)"testNestedWorkContexts3() passed");
    }

    public void testWorkContextProvider() throws Exception {
        Vector log = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"testing testWorkContextProvider()");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck = "SUCCESS:  WorkContextProvider causes expected WorkRejectedException";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)("testWorkContextProvider() failed - could not find string: " + toCheck));
            throw new Exception("testWorkContextProvider() failed.");
        }
        TestUtil.logMsg((String)"testWorkContextProvider() passed");
    }

    public void testWorkContextNotifications() throws Exception {
        Vector log = null;
        int iWorkAcceptedCount = -1;
        int iWorkStartedCount = -1;
        int iWorkCompletedCount = -1;
        int iContextSetupCompleteCount = -1;
        String toCheck1 = "notifications test: workAccepted(): count=";
        String toCheck2 = "notifications test: workStarted(): count=";
        String toCheck3 = "notifications test: contextSetupComplete(): count=";
        String toCheck4 = "notifications test: workCompleted(): count=";
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                iWorkAcceptedCount = Integer.parseInt(str.substring(toCheck1.length()));
            }
            if (str.startsWith(toCheck2)) {
                iWorkStartedCount = Integer.parseInt(str.substring(toCheck2.length()));
            }
            if (str.startsWith(toCheck3)) {
                iContextSetupCompleteCount = Integer.parseInt(str.substring(toCheck3.length()));
            }
            if (!str.startsWith(toCheck4)) continue;
            iWorkCompletedCount = Integer.parseInt(str.substring(toCheck4.length()));
        }
        Object msg = "testWorkContextNotifications() failed with following values: ";
        msg = (String)msg + "iWorkAcceptedCount = " + iWorkAcceptedCount + "    ";
        msg = (String)msg + "iWorkStartedCount = " + iWorkStartedCount + "    ";
        msg = (String)msg + "iWorkCompletedCount = " + iWorkCompletedCount + "    ";
        msg = (String)msg + "iContextSetupCompleteCount = " + iContextSetupCompleteCount;
        TestUtil.logMsg((String)msg);
        if (iWorkAcceptedCount == -1 || iWorkStartedCount == -1 || iWorkCompletedCount == -1 || iContextSetupCompleteCount == -1) {
            throw new Exception("FAILURE:  testWorkContextNotifications() detected that some notifications never got recorded");
        }
        if (iWorkCompletedCount < iContextSetupCompleteCount) {
            throw new Exception("FAILURE:  contextSetupCompleted must be called befor workCompleted - but was not!");
        }
        TestUtil.logMsg((String)"contextSetupCompleted correctly called befor workCompleted");
        if (iWorkAcceptedCount >= iContextSetupCompleteCount || iWorkStartedCount >= iContextSetupCompleteCount) {
            throw new Exception("testWorkContextNotifications() failed.");
        }
        TestUtil.logMsg((String)"testWorkContextNotifications() passed");
    }

    public void testHICNotifications() throws Exception {
        Vector log = null;
        int iContextSetupFailedCount = -1;
        String toCheck1 = "notifications test: contextSetupFailed(): count=";
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            iContextSetupFailedCount = Integer.parseInt(str.substring(toCheck1.length()));
        }
        Object msg = "testWorkContextNotifications() failed with following values: ";
        msg = (String)msg + "iContextSetupFailedCount = " + iContextSetupFailedCount + "    ";
        TestUtil.logMsg((String)msg);
        if (iContextSetupFailedCount != -1) {
            throw new Exception("FAILURE:  testWorkContextNotifications() detected contextSetupFailed notification.");
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup");
        this.ds1.clearLog();
        try {
            this.con.close();
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

