/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.bm.singleton.rw;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.bm.singleton.rw.TxBean;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeUtil;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTestBeanBase;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTxBeanBase;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.util.logging.Level;

@Singleton
@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestBean
extends RWTestBeanBase {
    @Override
    @EJB(beanInterface=TxBean.class)
    public void setTxBean(RWTxBeanBase b) {
        this.txBean = b;
    }

    @PostConstruct
    private void postConstruct() {
        int[] ids = new int[]{1000, 2000};
        String[] brandNames = new String[]{"postConstructCoffee1", "postConstructCoffee2"};
        try {
            this.ut.begin();
            for (int i = 0; i < ids.length; ++i) {
                this.postConstructCoffees[i] = CoffeeUtil.findDeletePersist(ids[i], brandNames[i], this.em);
            }
            this.ut.commit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.ut.begin();
            boolean existingDataExpected = true;
            for (int i = 0; i < ids.length; ++i) {
                CoffeeUtil.findDelete(ids[i], existingDataExpected, this.em);
                Helper.getLogger().logp(Level.FINE, "TestBean", "postConstruct", "Deleted coffee but tx will be rolled back. id=" + ids[i]);
            }
            this.ut.rollback();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    private void preDestroy() {
        for (CoffeeEJBLite postConstructCoffee : this.postConstructCoffees) {
            CoffeeUtil.deleteCoffeeInNewUserTransaction(postConstructCoffee.getId(), this.em, this.ut);
        }
    }
}

