/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.UpdateStatus;

final class ImmutableUpdateStatus
implements UpdateStatus {
    @Nullable
    private final String state;
    private final Date startedAt;
    @Nullable
    private final Date completedAt;
    @Nullable
    private final String message;

    private ImmutableUpdateStatus(@Nullable String state, Date startedAt, @Nullable Date completedAt, @Nullable String message) {
        this.state = state;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.message = message;
    }

    @Override
    @JsonProperty(value="State")
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="StartedAt")
    public Date startedAt() {
        return this.startedAt;
    }

    @Override
    @JsonProperty(value="CompletedAt")
    @Nullable
    public Date completedAt() {
        return this.completedAt;
    }

    @Override
    @JsonProperty(value="Message")
    @Nullable
    public String message() {
        return this.message;
    }

    public final ImmutableUpdateStatus withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableUpdateStatus(value, this.startedAt, this.completedAt, this.message);
    }

    public final ImmutableUpdateStatus withStartedAt(Date value) {
        if (this.startedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "startedAt");
        return new ImmutableUpdateStatus(this.state, newValue, this.completedAt, this.message);
    }

    public final ImmutableUpdateStatus withCompletedAt(@Nullable Date value) {
        if (this.completedAt == value) {
            return this;
        }
        return new ImmutableUpdateStatus(this.state, this.startedAt, value, this.message);
    }

    public final ImmutableUpdateStatus withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableUpdateStatus(this.state, this.startedAt, this.completedAt, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateStatus && this.equalsByValue((ImmutableUpdateStatus)another);
    }

    private boolean equalsByValue(ImmutableUpdateStatus another) {
        return Objects.equals(this.state, another.state) && this.startedAt.equals(another.startedAt) && Objects.equals(this.completedAt, another.completedAt) && Objects.equals(this.message, another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + this.startedAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.completedAt);
        h += (h << 5) + Objects.hashCode(this.message);
        return h;
    }

    public String toString() {
        return "UpdateStatus{state=" + this.state + ", startedAt=" + String.valueOf(this.startedAt) + ", completedAt=" + String.valueOf(this.completedAt) + ", message=" + this.message + "}";
    }

    public static ImmutableUpdateStatus copyOf(UpdateStatus instance) {
        if (instance instanceof ImmutableUpdateStatus) {
            return (ImmutableUpdateStatus)instance;
        }
        return ImmutableUpdateStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_STARTED_AT = 1L;
        private long initBits = 1L;
        private String state;
        private Date startedAt;
        private Date completedAt;
        private String message;

        private Builder() {
        }

        public final Builder from(UpdateStatus instance) {
            String messageValue;
            Objects.requireNonNull(instance, "instance");
            String stateValue = instance.state();
            if (stateValue != null) {
                this.state(stateValue);
            }
            this.startedAt(instance.startedAt());
            Date completedAtValue = instance.completedAt();
            if (completedAtValue != null) {
                this.completedAt(completedAtValue);
            }
            if ((messageValue = instance.message()) != null) {
                this.message(messageValue);
            }
            return this;
        }

        @JsonProperty(value="State")
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="StartedAt")
        public final Builder startedAt(Date startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="CompletedAt")
        public final Builder completedAt(@Nullable Date completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @JsonProperty(value="Message")
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public ImmutableUpdateStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateStatus(this.state, this.startedAt, this.completedAt, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("startedAt");
            }
            return "Cannot build UpdateStatus, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

