
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link EndpointVirtualIp}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEndpointVirtualIp.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableEndpointVirtualIp
    implements EndpointVirtualIp {
  private final String networkId;
  private final @Nullable String addr;

  private ImmutableEndpointVirtualIp(String networkId, @Nullable String addr) {
    this.networkId = networkId;
    this.addr = addr;
  }

  /**
   * @return The value of the {@code networkId} attribute
   */
  @JsonProperty("NetworkID")
  @Override
  public String networkId() {
    return networkId;
  }

  /**
   * @return The value of the {@code addr} attribute
   */
  @JsonProperty("Addr")
  @Override
  public @Nullable String addr() {
    return addr;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointVirtualIp#networkId() networkId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for networkId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableEndpointVirtualIp withNetworkId(String value) {
    String newValue = Objects.requireNonNull(value, "networkId");
    if (this.networkId.equals(newValue)) return this;
    return new ImmutableEndpointVirtualIp(newValue, this.addr);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointVirtualIp#addr() addr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addr (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableEndpointVirtualIp withAddr(@Nullable String value) {
    if (Objects.equals(this.addr, value)) return this;
    return new ImmutableEndpointVirtualIp(this.networkId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEndpointVirtualIp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEndpointVirtualIp
        && equalsByValue((ImmutableEndpointVirtualIp) another);
  }

  private boolean equalsByValue(ImmutableEndpointVirtualIp another) {
    return networkId.equals(another.networkId)
        && Objects.equals(addr, another.addr);
  }

  /**
   * Computes a hash code from attributes: {@code networkId}, {@code addr}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + networkId.hashCode();
    h += (h << 5) + Objects.hashCode(addr);
    return h;
  }

  /**
   * Prints the immutable value {@code EndpointVirtualIp} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EndpointVirtualIp{"
        + "networkId=" + networkId
        + ", addr=" + addr
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EndpointVirtualIp} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EndpointVirtualIp instance
   */
  public static ImmutableEndpointVirtualIp copyOf(EndpointVirtualIp instance) {
    if (instance instanceof ImmutableEndpointVirtualIp) {
      return (ImmutableEndpointVirtualIp) instance;
    }
    return ImmutableEndpointVirtualIp.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEndpointVirtualIp ImmutableEndpointVirtualIp}.
   * <pre>
   * ImmutableEndpointVirtualIp.builder()
   *    .networkId(String) // required {@link EndpointVirtualIp#networkId() networkId}
   *    .addr(String | null) // nullable {@link EndpointVirtualIp#addr() addr}
   *    .build();
   * </pre>
   * @return A new ImmutableEndpointVirtualIp builder
   */
  public static ImmutableEndpointVirtualIp.Builder builder() {
    return new ImmutableEndpointVirtualIp.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEndpointVirtualIp ImmutableEndpointVirtualIp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_NETWORK_ID = 0x1L;
    private long initBits = 0x1L;

    private String networkId;
    private String addr;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EndpointVirtualIp} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EndpointVirtualIp instance) {
      Objects.requireNonNull(instance, "instance");
      this.networkId(instance.networkId());
      @Nullable String addrValue = instance.addr();
      if (addrValue != null) {
        addr(addrValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointVirtualIp#networkId() networkId} attribute.
     * @param networkId The value for networkId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NetworkID")
    public final Builder networkId(String networkId) {
      this.networkId = Objects.requireNonNull(networkId, "networkId");
      initBits &= ~INIT_BIT_NETWORK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointVirtualIp#addr() addr} attribute.
     * @param addr The value for addr (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Addr")
    public final Builder addr(@Nullable String addr) {
      this.addr = addr;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEndpointVirtualIp ImmutableEndpointVirtualIp}.
     * @return An immutable instance of EndpointVirtualIp
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEndpointVirtualIp build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEndpointVirtualIp(networkId, addr);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NETWORK_ID) != 0) attributes.add("networkId");
      return "Cannot build EndpointVirtualIp, some of required attributes are not set " + attributes;
    }
  }
}
