/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations;

import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationAttributeRule;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationValidator;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.RangeExpressionException;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationValidatorTest {
    @Test
    public void noRule() throws RangeExpressionException {
        AnnotationValidator validator = new AnnotationValidator();
        String result = validator.validate("-1", null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGreaterThanOrEqual() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("0", "0", null);
        AnnotationValidatorTest.assertValidation("0", "1", null);
        AnnotationValidatorTest.assertValidation("0", "-1", "The value `-1` must be greater than or equal to `0`.");
    }

    @Test
    public void testGreaterThanOrEqual2() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("[0", "0", null);
        AnnotationValidatorTest.assertValidation("[0", "1", null);
        AnnotationValidatorTest.assertValidation("[0", "-1", "The value `-1` must be greater than or equal to `0`.");
    }

    @Test
    public void testGreaterThanOrEqualWithNegativeValue() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("-1", "0", null);
        AnnotationValidatorTest.assertValidation("-1", "1", null);
        AnnotationValidatorTest.assertValidation("-1", "-1", null);
        AnnotationValidatorTest.assertValidation("-1", "-2", "The value `-2` must be greater than or equal to `-1`.");
    }

    @Test
    public void testGreaterThan() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("(0", "0.1", null);
        AnnotationValidatorTest.assertValidation("(0", "0", "The value `0` must be greater than `0`.");
        AnnotationValidatorTest.assertValidation("(0", "-1", "The value `-1` must be greater than `0`.");
    }

    @Test
    public void testBetweenInclusive() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("[0,2]", "0", null);
        AnnotationValidatorTest.assertValidation("[0,2]", "1", null);
        AnnotationValidatorTest.assertValidation("[0,2]", "2", null);
        AnnotationValidatorTest.assertValidation("[0,2]", "-1", "The value `-1` must be between `0` (inclusive) and `2` (inclusive).");
    }

    @Test
    public void testBetweenFromExclusive() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("(0,2]", "0", "The value `0` must be between `0` (exclusive) and `2` (inclusive).");
        AnnotationValidatorTest.assertValidation("(0,2]", "1", null);
        AnnotationValidatorTest.assertValidation("(0,2]", "2", null);
        AnnotationValidatorTest.assertValidation("(0,2]", "-1", "The value `-1` must be between `0` (exclusive) and `2` (inclusive).");
    }

    @Test
    public void testBetweenToExclusive() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("[0,2)", "0", null);
        AnnotationValidatorTest.assertValidation("[0,2)", "1", null);
        AnnotationValidatorTest.assertValidation("[0,2)", "2", "The value `2` must be between `0` (inclusive) and `2` (exclusive).");
        AnnotationValidatorTest.assertValidation("[0,2)", "-1", "The value `-1` must be between `0` (inclusive) and `2` (exclusive).");
    }

    @Test
    public void testBetweenBothExclusive() throws RangeExpressionException {
        AnnotationValidatorTest.assertValidation("(0,2)", "0", "The value `0` must be between `0` (exclusive) and `2` (exclusive).");
        AnnotationValidatorTest.assertValidation("(0,2)", "1", null);
        AnnotationValidatorTest.assertValidation("(0,2)", "2", "The value `2` must be between `0` (exclusive) and `2` (exclusive).");
        AnnotationValidatorTest.assertValidation("(0,2)", "-1", "The value `-1` must be between `0` (exclusive) and `2` (exclusive).");
    }

    private static void assertValidation(String range, String value, String errorMessage) throws RangeExpressionException {
        AnnotationValidator validator = new AnnotationValidator();
        AnnotationAttributeRule rule = new AnnotationAttributeRule("foo");
        rule.setRange(range);
        String result = validator.validate(value, rule);
        Assert.assertEquals((Object)errorMessage, (Object)result);
    }
}

