/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.faulttolerance.java;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.jdt.core.java.completion.IJavaCompletionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.completion.JavaCompletionContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileFaultToleranceCompletionParticipant
implements IJavaCompletionParticipant {
    private static final Pattern FALLBACK_METHOD_KEY_VALUE_PATTERN = Pattern.compile("fallbackMethod\\s*=\\s*\"([^\"]*)\"");
    private static final String FALLBACK_ANNOTATION_SHORT_NAME = "org.eclipse.microprofile.faulttolerance.Fallback".substring("org.eclipse.microprofile.faulttolerance.Fallback".lastIndexOf(46) + 1);

    @Override
    public boolean isAdaptedForCompletion(JavaCompletionContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.faulttolerance.Fallback") != null;
    }

    @Override
    public List<? extends CompletionItem> collectCompletionItems(JavaCompletionContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return null;
        }
        IAnnotation fallbackAnnotation = MicroProfileFaultToleranceCompletionParticipant.getFallbackAnnotation(context.getTypeRoot(), context.getOffset());
        if (fallbackAnnotation == null) {
            return null;
        }
        Range range = MicroProfileFaultToleranceCompletionParticipant.getCompletionReplaceRange(fallbackAnnotation, context.getUtils(), context.getOffset());
        if (range == null) {
            return null;
        }
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        IMethod[] iMethodArray = context.getTypeRoot().findPrimaryType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.equals(fallbackAnnotation.getParent())) {
                completionItems.add(MicroProfileFaultToleranceCompletionParticipant.makeMethodCompletionItem(method.getElementName(), range));
            }
            ++n2;
        }
        return completionItems;
    }

    private static IAnnotation getFallbackAnnotation(ITypeRoot typeRoot, int offset) throws JavaModelException {
        IJavaElement element = typeRoot.getElementAt(offset);
        if (element.getElementType() != 9) {
            return null;
        }
        IAnnotatable annotatable = (IAnnotatable)element;
        IAnnotation annotation = annotatable.getAnnotation(FALLBACK_ANNOTATION_SHORT_NAME);
        if (!AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Fallback")) {
            return null;
        }
        return annotation;
    }

    private static Range getCompletionReplaceRange(IAnnotation fallbackAnnotation, IJDTUtils utils, int triggerOffset) throws JavaModelException {
        ISourceRange range = fallbackAnnotation.getSourceRange();
        if (!SourceRange.isAvailable((ISourceRange)range)) {
            return null;
        }
        int annotationStart = range.getOffset();
        String annotationSrc = fallbackAnnotation.getSource();
        Matcher m = FALLBACK_METHOD_KEY_VALUE_PATTERN.matcher(annotationSrc);
        if (!m.find()) {
            return null;
        }
        if (m.start(1) == -1 || m.end(1) == -1) {
            return null;
        }
        int start = m.start(1) + annotationStart;
        int length = m.end(1) - m.start(1);
        if (triggerOffset < start || start + length < triggerOffset) {
            return null;
        }
        return utils.toRange(fallbackAnnotation.getOpenable(), start, length);
    }

    private static CompletionItem makeMethodCompletionItem(String methodName, Range replaceRange) {
        CompletionItem completionItem = new CompletionItem();
        TextEdit textEdit = new TextEdit(replaceRange, methodName);
        completionItem.setTextEdit(Either.forLeft((Object)textEdit));
        completionItem.setKind(CompletionItemKind.Method);
        completionItem.setLabel(methodName + "()");
        return completionItem;
    }
}

