/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ModelExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExtentHelper {
    private final OperationalTransformation fTransformation;
    private final List<URI> fModelExtentURIs;
    private final LinkedHashMap<ModelParameter, ExtentEntry> fExtentMap;
    private final ResourceSet fResourceSet;

    public ModelExtentHelper(OperationalTransformation transformation, List<URI> modelExtentURIs, ResourceSet resSet) {
        if (transformation == null || modelExtentURIs == null || modelExtentURIs.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.fTransformation = transformation;
        this.fModelExtentURIs = modelExtentURIs;
        this.fExtentMap = new LinkedHashMap();
        this.fResourceSet = resSet;
    }

    public ModelExtentHelper(OperationalTransformation transformation, List<URI> modelExtentURIs) {
        this(transformation, modelExtentURIs, (ResourceSet)new ResourceSetImpl());
    }

    public ResourceSet getResourceSet() {
        return this.fResourceSet;
    }

    public Diagnostic saveExtents() {
        BasicDiagnostic diagnostic = QvtPlugin.createDiagnostic("Save model param extents diagnostic");
        for (ExtentEntry nextEntry : this.fExtentMap.values()) {
            Diagnostic saveResDiagnostic;
            URI saveAsURI = nextEntry.saveAsURI;
            if (saveAsURI == null) continue;
            Resource res = this.fResourceSet.getResource(saveAsURI, false);
            if (res == null) {
                res = this.fResourceSet.createResource(saveAsURI);
            }
            if (res == null) {
                diagnostic.add(QvtPlugin.createWarnDiagnostic("No resistered factory for resource uri=" + saveAsURI));
                res = new XMIResourceImpl(saveAsURI);
                this.fResourceSet.getResources().add((Object)res);
            }
            if ((saveResDiagnostic = this.saveContents(res, nextEntry.extent.getContents())).getSeverity() == 0) continue;
            diagnostic.add(saveResDiagnostic);
        }
        return diagnostic;
    }

    private Diagnostic saveContents(Resource res, List<EObject> contents) {
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        options.put("ENCODING", "UTF-8");
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        for (EObject eObject : contents) {
            if (!ModelExtentHelper.isDynamic(eObject)) continue;
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            break;
        }
        try {
            res.getContents().addAll(contents);
            res.save(options);
        }
        catch (IOException e) {
            return QvtPlugin.createErrorDiagnostic("Failed to save model extent uri=" + res.getURI(), e);
        }
        return Diagnostic.OK_INSTANCE;
    }

    public List<ModelExtent> loadExtents() throws DiagnosticException {
        this.fResourceSet.getResources().clear();
        EList<ModelParameter> params = this.fTransformation.getModelParameter();
        if (params.size() != this.fModelExtentURIs.size()) {
            throw new DiagnosticException(QvtPlugin.createErrorDiagnostic(NLS.bind(Messages.InvalidModelParameterCountError, this.fModelExtentURIs.size(), params.size()), null));
        }
        int i = 0;
        for (URI uri : this.fModelExtentURIs) {
            ModelParameter nextParam;
            DirectionKind kind;
            URI saveAsURI = (kind = (nextParam = (ModelParameter)params.get(i++)).getKind()) != DirectionKind.IN ? uri : null;
            URI loadURI = kind != DirectionKind.OUT ? uri : null;
            ModelExtent extent = loadURI != null ? this.loadExtent(nextParam, loadURI, this.fResourceSet) : new BasicModelExtent();
            ExtentEntry entry = new ExtentEntry(extent, saveAsURI);
            this.fExtentMap.put(nextParam, entry);
        }
        return this.getExtents();
    }

    private ModelExtent loadExtent(ModelParameter modelParameter, URI uri, ResourceSet rs) throws DiagnosticException {
        Throwable error;
        try {
            Iterator iterator;
            Resource res = rs.getResource(uri, true);
            EList contents = res.getContents();
            if (!res.getErrors().isEmpty() && (iterator = res.getErrors().iterator()).hasNext()) {
                Resource.Diagnostic d = (Resource.Diagnostic)iterator.next();
                throw new DiagnosticException(QvtPlugin.createErrorDiagnostic(d.getMessage(), null));
            }
            return new BasicModelExtent((List<? extends EObject>)contents);
        }
        catch (WrappedException e) {
            error = e.getCause() != null ? e.getCause() : e;
        }
        catch (RuntimeException e) {
            error = e;
        }
        throw new DiagnosticException(QvtPlugin.createErrorDiagnostic("Failed to load model extent uri=" + uri, error));
    }

    private List<ModelExtent> getExtents() {
        ArrayList<ModelExtent> result = new ArrayList<ModelExtent>(this.fExtentMap.size());
        for (ExtentEntry extentEntry : this.fExtentMap.values()) {
            result.add(extentEntry.extent);
        }
        return result;
    }

    private static boolean isDynamic(EObject eObject) {
        return eObject instanceof EStructuralFeature.Internal.DynamicValueHolder;
    }

    private static class ExtentEntry {
        final ModelExtent extent;
        final URI saveAsURI;

        ExtentEntry(ModelExtent extent, URI saveAsURI) {
            assert (extent != null);
            this.extent = extent;
            this.saveAsURI = saveAsURI;
        }
    }
}

