/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.uml;

import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigTest.Requires(value={"model.legacy"})
public class LegacyDynamicPackageTest
extends AbstractCDOTest {
    private final EPackage stuffPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/cdo/tests/schema/stuff/1.0");
    private final EFactory originalStuffFactory = this.stuffPackage.getEFactoryInstance();
    private final EClass thingClass = (EClass)this.stuffPackage.getEClassifier("Thing");
    private final EClass propertyClass = (EClass)this.stuffPackage.getEClassifier("Property");
    private final EClass worldClass = (EClass)this.stuffPackage.getEClassifier("World");
    private final EAttribute thingName = (EAttribute)this.thingClass.getEStructuralFeature("name");
    private final EReference thingProperties = (EReference)this.thingClass.getEStructuralFeature("properties");
    private final EAttribute propertyName = (EAttribute)this.propertyClass.getEStructuralFeature("name");
    private final EAttribute propertyIntrinsic = (EAttribute)this.propertyClass.getEStructuralFeature("intrinsic");
    private final EReference worldProperties = (EReference)this.worldClass.getEStructuralFeature("propertiesOfThings");
    private final EReference worldThings = (EReference)this.worldClass.getEStructuralFeature("things");

    public void testInstancesOfRegisteredDynamicPackage() throws Exception {
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(this.stuffPackage);
        CDOPackageInfo info = session.getPackageRegistry().getPackageInfo(this.stuffPackage);
        CDOPackageUnit unit = info.getPackageUnit();
        LegacyDynamicPackageTest.assertEquals((Object)CDOPackageUnit.Type.DYNAMIC, (Object)unit.getOriginalType());
        LegacyDynamicPackageTest.assertEquals((Object)CDOPackageUnit.State.NEW, (Object)unit.getState());
        EFactory stuffFactory = this.stuffPackage.getEFactoryInstance();
        EObject world = stuffFactory.create(this.worldClass);
        EObject colour = stuffFactory.create(this.propertyClass);
        colour.eSet((EStructuralFeature)this.propertyName, (Object)"colour");
        colour.eSet((EStructuralFeature)this.propertyIntrinsic, (Object)true);
        EObject apple = stuffFactory.create(this.thingClass);
        apple.eSet((EStructuralFeature)this.thingName, (Object)"apple");
        this.list(apple, (EStructuralFeature)this.thingProperties).add((Object)colour);
        this.list(world, (EStructuralFeature)this.worldProperties).add((Object)colour);
        this.list(world, (EStructuralFeature)this.worldThings).add((Object)apple);
        EObject oldWorld = EcoreUtil.copy((EObject)world);
        CDOTransaction transaction = session.openTransaction();
        CDOResource res = transaction.createResource(this.getResourcePath("/world1.stuff"));
        res.getContents().add((Object)world);
        transaction.commit();
        session.close();
        session = this.openSession();
        transaction = session.openTransaction();
        res = transaction.getResource(this.getResourcePath("/world1.stuff"), true);
        LegacyDynamicPackageTest.assertEquals((boolean)true, (boolean)res.isLoaded());
        LegacyDynamicPackageTest.assertEquals((int)1, (int)res.getContents().size());
        EObject newWorld = (EObject)res.getContents().get(0);
        EPackage newPackage = newWorld.eClass().getEPackage();
        LegacyDynamicPackageTest.assertSame((Object)this.stuffPackage, (Object)newPackage);
        info = session.getPackageRegistry().getPackageInfo(this.stuffPackage);
        unit = info.getPackageUnit();
        LegacyDynamicPackageTest.assertEquals((Object)CDOPackageUnit.Type.DYNAMIC, (Object)unit.getOriginalType());
        LegacyDynamicPackageTest.assertEquals((Object)CDOPackageUnit.State.LOADED, (Object)unit.getState());
        LegacyDynamicPackageTest.assertEquals((boolean)true, (boolean)EcoreUtil.equals((EObject)oldWorld, (EObject)newWorld));
    }

    protected void doTearDown() throws Exception {
        this.stuffPackage.setEFactoryInstance(this.originalStuffFactory);
        super.doTearDown();
    }

    private <T> EList<T> list(EObject owner, EStructuralFeature feature) {
        return (EList)owner.eGet(feature);
    }
}

