/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.emf.cdo.internal.migrator.tasks.AbstractPropertyTask;

public class AutomaticBuildTask
extends AbstractPropertyTask {
    private Boolean enable;
    private String _if;

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setIf(String _if) {
        this._if = _if;
    }

    protected void checkAttributes() throws BuildException {
        super.checkAttributes();
        AutomaticBuildTask.assertTrue("'enable' must be specified.", this.enable != null);
    }

    protected String doCompute() throws Exception {
        if (AutomaticBuildTask.isSet(this._if) && !TRUE.equals(this.getProject().getProperty(this._if))) {
            return FALSE;
        }
        IWorkspaceDescription description = this.workspace.getDescription();
        boolean wasEnabled = description.isAutoBuilding();
        if (wasEnabled == this.enable) {
            return FALSE;
        }
        description.setAutoBuilding(this.enable.booleanValue());
        this.workspace.setDescription(description);
        this.verbose("Automatic build " + (this.enable != false ? "enabled" : "disabled"));
        return TRUE;
    }
}

