/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om.pref;

import org.eclipse.net4j.internal.util.om.pref.Preferences;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.pref.OMPreference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preference<T>
implements OMPreference<T> {
    private Preferences preferences;
    private String name;
    private T defaultValue;
    private T value;

    public Preference(Preferences preferences, String name, T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue == null");
        }
        this.preferences = preferences;
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @Override
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T getValue() {
        this.load();
        return this.value;
    }

    @Override
    public T setValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        this.load();
        T oldValue = this.value;
        if (!this.equals(oldValue, value)) {
            if (this.equals(this.defaultValue, value)) {
                value = this.defaultValue;
            }
            this.value = value;
            this.preferences.fireChangeEvent(this, oldValue, value);
            return oldValue;
        }
        return null;
    }

    @Override
    public boolean isSet() {
        return !this.equals(this.defaultValue, this.value);
    }

    @Override
    public T unSet() {
        return this.setValue(this.defaultValue);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " = " + this.getValue();
    }

    protected boolean equals(T v1, T v2) {
        return ObjectUtil.equals(v1, v2);
    }

    protected void init(String value) {
        this.value = value == null ? this.defaultValue : this.convert(value);
    }

    protected abstract T convert(String var1);

    protected abstract String getString();

    private void load() {
        this.preferences.load();
    }
}

