/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.security.INegotiationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NegotiationContext
implements INegotiationContext {
    private INegotiationContext.Receiver receiver;
    private Enum<?> state;
    private Object info;
    private CountDownLatch finishedLatch = new CountDownLatch(1);

    @Override
    public INegotiationContext.Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public void setReceiver(INegotiationContext.Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Enum<?> getState() {
        return this.state;
    }

    @Override
    public void setState(Enum<?> state) {
        this.state = state;
    }

    @Override
    public Object getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(Object info) {
        this.info = info;
    }

    @Override
    public void setFinished(boolean success) {
        if (this.finishedLatch != null) {
            this.finishedLatch.countDown();
        }
    }

    @Override
    public Enum<?> waitUntilFinished(long timeout) {
        if (this.finishedLatch == null) {
            throw new IllegalStateException("finishedLatch == null");
        }
        try {
            try {
                if (timeout == -1L) {
                    this.finishedLatch.await();
                } else {
                    this.finishedLatch.await(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap(ex);
            }
        }
        finally {
            this.finishedLatch = null;
        }
        return this.state;
    }
}

